/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.urls;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.XYDataset;

public class TimeSeriesURLGenerator
implements XYURLGenerator,
Serializable {
    private DateFormat dateFormat = DateFormat.getInstance();
    private String prefix = "index.html";
    private String seriesParameterName = "series";
    private String itemParameterName = "item";

    public TimeSeriesURLGenerator() {
    }

    public TimeSeriesURLGenerator(DateFormat dDateFormat, String sPrefix, String sSeriesParameterName, String sItemParameterName) {
        this.dateFormat = dDateFormat;
        this.prefix = sPrefix;
        this.seriesParameterName = sSeriesParameterName;
        this.itemParameterName = sItemParameterName;
    }

    public String generateURL(XYDataset dataset, int series, int item) {
        String result = this.prefix;
        boolean firstParameter = result.indexOf("?") == -1;
        String seriesName = dataset.getSeriesName(series);
        if (seriesName != null) {
            result = String.valueOf(result) + (firstParameter ? "?" : "&");
            result = String.valueOf(result) + this.seriesParameterName + "=" + seriesName;
            firstParameter = false;
        }
        long x = dataset.getXValue(series, item).longValue();
        String xValue = this.dateFormat.format(new Date(x));
        result = String.valueOf(result) + (firstParameter ? "?" : "&");
        result = String.valueOf(result) + this.itemParameterName + "=" + xValue;
        return result;
    }
}

