/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.urls.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.urls.StandardPieURLGenerator;
import org.jfree.data.DefaultPieDataset;

public class StandardPieURLGeneratorTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.urls.junit.StandardPieURLGeneratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public StandardPieURLGeneratorTests(String name) {
        super(name);
    }

    public void testSerialization() {
        StandardPieURLGenerator g1 = new StandardPieURLGenerator("index.html?", "cat");
        StandardPieURLGenerator g2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(g1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            g2 = (StandardPieURLGenerator)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)g1, g2);
    }

    public void testURL() {
        DefaultPieDataset dataset = new DefaultPieDataset();
        dataset.setValue((Comparable)((Object)"Alpha"), new Double(5.0));
        dataset.setValue((Comparable)((Object)"Beta"), new Double(5.5));
        StandardPieURLGenerator g1 = new StandardPieURLGenerator("chart.jsp", "category");
        String url = g1.generateURL(dataset, (Comparable)((Object)"Beta"), 0);
        Assert.assertEquals((String)"chart.jsp?category=Beta&pieIndex=0", (String)url);
    }
}

