/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.xml.test;

import java.awt.Dimension;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.demo.JFreeChartDemoBase;
import org.jfree.chart.xml.parser.JFreeChartRootReadHandler;
import org.jfree.chart.xml.writer.JFreeChartRootWriteHandler;
import org.jfree.util.Log;
import org.jfree.util.PrintStreamLogTarget;
import org.jfree.xml.writer.XMLWriter;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class ChartIoTest {
    public static void main(String[] args) throws Exception {
        Log.getInstance().addTarget(new PrintStreamLogTarget());
        JFreeChartDemoBase demo = new JFreeChartDemoBase();
        JFreeChart chart = demo.createScatterPlot();
        Writer stringWriter = null;
        if (args.length == 1) {
            stringWriter = new FileWriter(args[0]);
        } else {
            Log.debug("Args: " + args.length);
            stringWriter = new StringWriter();
        }
        XMLWriter writer = new XMLWriter(stringWriter);
        JFreeChartRootWriteHandler rootHandler = new JFreeChartRootWriteHandler();
        rootHandler.writeChart(chart, writer);
        writer.close();
        if (args.length != 1) {
            System.out.println(stringWriter);
        }
        JFreeChartRootReadHandler handler = new JFreeChartRootReadHandler();
        handler.putObject("::dataset", chart.getXYPlot().getDataset());
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        if (args.length == 1) {
            saxParser.parse((InputStream)new FileInputStream(args[0]), (DefaultHandler)handler);
        } else {
            saxParser.parse(new InputSource(new StringReader(writer.toString())), (DefaultHandler)handler);
        }
        ChartFrame frame1 = new ChartFrame("Before", chart);
        frame1.getChartPanel().setPreferredSize(new Dimension(500, 270));
        frame1.pack();
        frame1.show();
        ChartFrame frame2 = new ChartFrame("After", handler.getChart());
        frame2.getChartPanel().setPreferredSize(new Dimension(500, 270));
        frame2.pack();
        frame2.setLocation(frame2.getX(), frame2.getY() + frame1.getHeight());
        frame2.show();
    }
}

