/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.CategoryDataset;
import org.jfree.data.Dataset;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.data.DefaultPieDataset;
import org.jfree.data.DomainInfo;
import org.jfree.data.Function2D;
import org.jfree.data.HighLowDataset;
import org.jfree.data.IntervalCategoryDataset;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.KeyToGroupMap;
import org.jfree.data.KeyedValues;
import org.jfree.data.PieDataset;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.TableXYDataset;
import org.jfree.data.XYDataset;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;

public final class DatasetUtilities {
    private DatasetUtilities() {
    }

    public static Number[] createNumberArray(double[] data) {
        Number[] result = new Number[data.length];
        int i = 0;
        while (i < data.length) {
            result[i] = new Double(data[i]);
            ++i;
        }
        return result;
    }

    public static Number[][] createNumberArray2D(double[][] data) {
        int l1 = data.length;
        int l2 = data[0].length;
        Number[][] result = new Number[l1][l2];
        int i = 0;
        while (i < l1) {
            result[i] = DatasetUtilities.createNumberArray(data[i]);
            ++i;
        }
        return result;
    }

    public static Range findDomainExtent(Dataset dataset) {
        if (dataset == null) {
            return null;
        }
        if (dataset instanceof CategoryDataset && !(dataset instanceof XYDataset)) {
            throw new IllegalArgumentException("The dataset does not have a numerical domain.");
        }
        if (dataset instanceof DomainInfo) {
            DomainInfo info = (DomainInfo)((Object)dataset);
            return info.getDomainRange();
        }
        if (dataset instanceof XYDataset) {
            return DatasetUtilities.iterateDomainExtent((XYDataset)dataset);
        }
        return null;
    }

    public static Range iterateDomainExtent(XYDataset dataset) {
        if (dataset == null) {
            return null;
        }
        double minimum = Double.POSITIVE_INFINITY;
        double maximum = Double.NEGATIVE_INFINITY;
        int seriesCount = dataset.getSeriesCount();
        int series = 0;
        while (series < seriesCount) {
            int itemCount = dataset.getItemCount(series);
            int item = 0;
            while (item < itemCount) {
                double uvalue;
                double lvalue;
                if (dataset instanceof IntervalXYDataset) {
                    IntervalXYDataset intervalXYData = (IntervalXYDataset)dataset;
                    lvalue = intervalXYData.getStartX(series, item);
                    uvalue = intervalXYData.getEndX(series, item);
                } else {
                    uvalue = lvalue = dataset.getX(series, item);
                }
                minimum = Math.min(minimum, lvalue);
                maximum = Math.max(maximum, uvalue);
                ++item;
            }
            ++series;
        }
        if (minimum > maximum) {
            return null;
        }
        return new Range(minimum, maximum);
    }

    public static Range findRangeExtent(Dataset dataset) {
        if (dataset == null) {
            return null;
        }
        if (dataset instanceof RangeInfo) {
            RangeInfo info = (RangeInfo)((Object)dataset);
            return info.getValueRange();
        }
        if (dataset instanceof CategoryDataset) {
            return DatasetUtilities.iterateCategoryRangeExtent((CategoryDataset)dataset);
        }
        if (dataset instanceof XYDataset) {
            return DatasetUtilities.iterateXYRangeExtent((XYDataset)dataset);
        }
        return null;
    }

    public static Range iterateCategoryRangeExtent(CategoryDataset dataset) {
        double minimum = Double.POSITIVE_INFINITY;
        double maximum = Double.NEGATIVE_INFINITY;
        int rowCount = dataset.getRowCount();
        int columnCount = dataset.getColumnCount();
        int row = 0;
        while (row < rowCount) {
            int column = 0;
            while (column < columnCount) {
                Number uvalue;
                Number lvalue;
                if (dataset instanceof IntervalCategoryDataset) {
                    IntervalCategoryDataset icd = (IntervalCategoryDataset)dataset;
                    lvalue = icd.getStartValue(row, column);
                    uvalue = icd.getEndValue(row, column);
                } else {
                    uvalue = lvalue = dataset.getValue(row, column);
                }
                if (lvalue != null) {
                    minimum = Math.min(minimum, lvalue.doubleValue());
                }
                if (uvalue != null) {
                    maximum = Math.max(maximum, uvalue.doubleValue());
                }
                ++column;
            }
            ++row;
        }
        if (minimum == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(minimum, maximum);
    }

    public static Range iterateXYRangeExtent(XYDataset dataset) {
        double minimum = Double.POSITIVE_INFINITY;
        double maximum = Double.NEGATIVE_INFINITY;
        int seriesCount = dataset.getSeriesCount();
        int series = 0;
        while (series < seriesCount) {
            int itemCount = dataset.getItemCount(series);
            int item = 0;
            while (item < itemCount) {
                double uvalue;
                double lvalue;
                if (dataset instanceof IntervalXYDataset) {
                    IntervalXYDataset intervalXYData = (IntervalXYDataset)dataset;
                    lvalue = intervalXYData.getStartY(series, item);
                    uvalue = intervalXYData.getEndY(series, item);
                } else if (dataset instanceof HighLowDataset) {
                    HighLowDataset highLowData = (HighLowDataset)dataset;
                    lvalue = highLowData.getLow(series, item);
                    uvalue = highLowData.getHigh(series, item);
                } else {
                    uvalue = lvalue = dataset.getY(series, item);
                }
                if (!Double.isNaN(lvalue)) {
                    minimum = Math.min(minimum, lvalue);
                }
                if (!Double.isNaN(uvalue)) {
                    maximum = Math.max(maximum, uvalue);
                }
                ++item;
            }
            ++series;
        }
        if (minimum == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(minimum, maximum);
    }

    public static Number findMinimumDomainValue(Dataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        if (dataset instanceof CategoryDataset && !(dataset instanceof XYDataset)) {
            throw new IllegalArgumentException("CategoryDataset does not have a numerical domain.");
        }
        if (dataset instanceof DomainInfo) {
            DomainInfo info = (DomainInfo)((Object)dataset);
            return info.getMinimumDomainValue();
        }
        if (dataset instanceof XYDataset) {
            double minimum = Double.POSITIVE_INFINITY;
            XYDataset xyData = (XYDataset)dataset;
            int seriesCount = xyData.getSeriesCount();
            int series = 0;
            while (series < seriesCount) {
                int itemCount = xyData.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    double value;
                    if (dataset instanceof IntervalXYDataset) {
                        IntervalXYDataset intervalXYData = (IntervalXYDataset)dataset;
                        value = intervalXYData.getStartX(series, item);
                    } else {
                        value = xyData.getX(series, item);
                    }
                    if (!Double.isNaN(value)) {
                        minimum = Math.min(minimum, value);
                    }
                    ++item;
                }
                ++series;
            }
            if (minimum == Double.POSITIVE_INFINITY) {
                return null;
            }
            return new Double(minimum);
        }
        return null;
    }

    public static Number getMaximumDomainValue(Dataset data) {
        if (data == null) {
            throw new IllegalArgumentException("Datasets.getMaximumDomainValue: null dataset not allowed.");
        }
        if (data instanceof CategoryDataset && !(data instanceof XYDataset)) {
            throw new IllegalArgumentException("Datasets.getMaximumDomainValue(...): CategoryDataset does not have numerical domain.");
        }
        if (data instanceof DomainInfo) {
            DomainInfo info = (DomainInfo)((Object)data);
            return info.getMaximumDomainValue();
        }
        if (data instanceof XYDataset) {
            XYDataset xyData = (XYDataset)data;
            double maximum = Double.NEGATIVE_INFINITY;
            int seriesCount = xyData.getSeriesCount();
            int series = 0;
            while (series < seriesCount) {
                int itemCount = xyData.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    Number value;
                    if (data instanceof IntervalXYDataset) {
                        IntervalXYDataset intervalXYData = (IntervalXYDataset)data;
                        value = intervalXYData.getEndXValue(series, item);
                    } else {
                        value = xyData.getXValue(series, item);
                    }
                    if (value != null) {
                        maximum = Math.max(maximum, value.doubleValue());
                    }
                    ++item;
                }
                ++series;
            }
            if (maximum == Double.NEGATIVE_INFINITY) {
                return null;
            }
            return new Double(maximum);
        }
        return null;
    }

    public static Number getMinimumRangeValue(Dataset data) {
        if (data == null) {
            throw new IllegalArgumentException("Datasets.getMinimumRangeValue: null dataset not allowed.");
        }
        if (data instanceof RangeInfo) {
            RangeInfo info = (RangeInfo)((Object)data);
            return info.getMinimumRangeValue();
        }
        if (data instanceof CategoryDataset) {
            CategoryDataset categoryData = (CategoryDataset)data;
            double minimum = Double.POSITIVE_INFINITY;
            int seriesCount = categoryData.getRowCount();
            int itemCount = categoryData.getColumnCount();
            int series = 0;
            while (series < seriesCount) {
                int item = 0;
                while (item < itemCount) {
                    Number value;
                    if (data instanceof IntervalCategoryDataset) {
                        IntervalCategoryDataset icd = (IntervalCategoryDataset)data;
                        value = icd.getStartValue(series, item);
                    } else {
                        value = categoryData.getValue(series, item);
                    }
                    if (value != null) {
                        minimum = Math.min(minimum, value.doubleValue());
                    }
                    ++item;
                }
                ++series;
            }
            if (minimum == Double.POSITIVE_INFINITY) {
                return null;
            }
            return new Double(minimum);
        }
        if (data instanceof XYDataset) {
            XYDataset xyData = (XYDataset)data;
            double minimum = Double.POSITIVE_INFINITY;
            int seriesCount = xyData.getSeriesCount();
            int series = 0;
            while (series < seriesCount) {
                int itemCount = xyData.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    Number value;
                    if (data instanceof IntervalXYDataset) {
                        IntervalXYDataset intervalXYData = (IntervalXYDataset)data;
                        value = intervalXYData.getStartYValue(series, item);
                    } else if (data instanceof HighLowDataset) {
                        HighLowDataset highLowData = (HighLowDataset)data;
                        value = highLowData.getLowValue(series, item);
                    } else {
                        value = xyData.getYValue(series, item);
                    }
                    if (value != null) {
                        minimum = Math.min(minimum, value.doubleValue());
                    }
                    ++item;
                }
                ++series;
            }
            if (minimum == Double.POSITIVE_INFINITY) {
                return null;
            }
            return new Double(minimum);
        }
        return null;
    }

    public static Number getMaximumRangeValue(Dataset data) {
        if (data == null) {
            throw new IllegalArgumentException("Datasets.getMinimumRangeValue: null dataset not allowed.");
        }
        if (data instanceof RangeInfo) {
            RangeInfo info = (RangeInfo)((Object)data);
            return info.getMaximumRangeValue();
        }
        if (data instanceof CategoryDataset) {
            CategoryDataset categoryData = (CategoryDataset)data;
            double maximum = Double.NEGATIVE_INFINITY;
            int seriesCount = categoryData.getRowCount();
            int itemCount = categoryData.getColumnCount();
            int series = 0;
            while (series < seriesCount) {
                int item = 0;
                while (item < itemCount) {
                    Number value;
                    if (data instanceof IntervalCategoryDataset) {
                        IntervalCategoryDataset icd = (IntervalCategoryDataset)data;
                        value = icd.getEndValue(series, item);
                    } else {
                        value = categoryData.getValue(series, item);
                    }
                    if (value != null) {
                        maximum = Math.max(maximum, value.doubleValue());
                    }
                    ++item;
                }
                ++series;
            }
            if (maximum == Double.NEGATIVE_INFINITY) {
                return null;
            }
            return new Double(maximum);
        }
        if (data instanceof XYDataset) {
            XYDataset xyData = (XYDataset)data;
            double maximum = Double.NEGATIVE_INFINITY;
            int seriesCount = xyData.getSeriesCount();
            int series = 0;
            while (series < seriesCount) {
                int itemCount = xyData.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    Number value;
                    if (data instanceof IntervalXYDataset) {
                        IntervalXYDataset intervalXYData = (IntervalXYDataset)data;
                        value = intervalXYData.getEndYValue(series, item);
                    } else if (data instanceof HighLowDataset) {
                        HighLowDataset highLowData = (HighLowDataset)data;
                        value = highLowData.getHighValue(series, item);
                    } else {
                        value = xyData.getYValue(series, item);
                    }
                    if (value != null) {
                        maximum = Math.max(maximum, value.doubleValue());
                    }
                    ++item;
                }
                ++series;
            }
            if (maximum == Double.NEGATIVE_INFINITY) {
                return null;
            }
            return new Double(maximum);
        }
        return null;
    }

    public static PieDataset createPieDatasetForRow(CategoryDataset data, Comparable rowKey) {
        int row = data.getRowIndex(rowKey);
        return DatasetUtilities.createPieDatasetForRow(data, row);
    }

    public static PieDataset createPieDatasetForRow(CategoryDataset data, int row) {
        DefaultPieDataset result = new DefaultPieDataset();
        int columnCount = data.getColumnCount();
        int current = 0;
        while (current < columnCount) {
            Comparable columnKey = data.getColumnKey(current);
            result.setValue(columnKey, data.getValue(row, current));
            ++current;
        }
        return result;
    }

    public static PieDataset createPieDatasetForColumn(CategoryDataset data, Comparable columnKey) {
        int column = data.getColumnIndex(columnKey);
        return DatasetUtilities.createPieDatasetForColumn(data, column);
    }

    public static PieDataset createPieDatasetForColumn(CategoryDataset data, int column) {
        DefaultPieDataset result = new DefaultPieDataset();
        int rowCount = data.getRowCount();
        int i = 0;
        while (i < rowCount) {
            Comparable rowKey = data.getRowKey(i);
            result.setValue(rowKey, data.getValue(i, column));
            ++i;
        }
        return result;
    }

    public static double calculatePieDatasetTotal(PieDataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        List keys = dataset.getKeys();
        double totalValue = 0.0;
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            Comparable current = (Comparable)iterator.next();
            if (current == null) continue;
            Number value = dataset.getValue(current);
            double v = 0.0;
            if (value != null) {
                v = value.doubleValue();
            }
            if (!(v > 0.0)) continue;
            totalValue += v;
        }
        return totalValue;
    }

    public static Range getStackedRangeExtent(CategoryDataset data) {
        Range result = null;
        if (data != null) {
            double minimum = 0.0;
            double maximum = 0.0;
            int categoryCount = data.getColumnCount();
            int item = 0;
            while (item < categoryCount) {
                double positive = 0.0;
                double negative = 0.0;
                int seriesCount = data.getRowCount();
                int series = 0;
                while (series < seriesCount) {
                    Number number = data.getValue(series, item);
                    if (number != null) {
                        double value = number.doubleValue();
                        if (value > 0.0) {
                            positive += value;
                        }
                        if (value < 0.0) {
                            negative += value;
                        }
                    }
                    ++series;
                }
                minimum = Math.min(minimum, negative);
                maximum = Math.max(maximum, positive);
                ++item;
            }
            result = new Range(minimum, maximum);
        }
        return result;
    }

    public static Range getStackedRangeExtent(CategoryDataset dataset, KeyToGroupMap map) {
        Range result = null;
        if (dataset != null) {
            int[] groupIndex = new int[dataset.getRowCount()];
            int i = 0;
            while (i < dataset.getRowCount()) {
                groupIndex[i] = map.getGroupIndex(map.getGroup(dataset.getRowKey(i)));
                ++i;
            }
            int groupCount = map.getGroupCount();
            double[] minimum = new double[groupCount];
            double[] maximum = new double[groupCount];
            int categoryCount = dataset.getColumnCount();
            int item = 0;
            while (item < categoryCount) {
                double[] positive = new double[groupCount];
                double[] negative = new double[groupCount];
                int seriesCount = dataset.getRowCount();
                int series = 0;
                while (series < seriesCount) {
                    Number number = dataset.getValue(series, item);
                    if (number != null) {
                        double value = number.doubleValue();
                        if (value > 0.0) {
                            positive[groupIndex[series]] = positive[groupIndex[series]] + value;
                        }
                        if (value < 0.0) {
                            negative[groupIndex[series]] = negative[groupIndex[series]] + value;
                        }
                    }
                    ++series;
                }
                int g = 0;
                while (g < groupCount) {
                    minimum[g] = Math.min(minimum[g], negative[g]);
                    maximum[g] = Math.max(maximum[g], positive[g]);
                    ++g;
                }
                ++item;
            }
            int j = 0;
            while (j < groupCount) {
                result = Range.combine(result, new Range(minimum[j], maximum[j]));
                ++j;
            }
        }
        return result;
    }

    public static Number getMinimumStackedRangeValue(CategoryDataset data) {
        Double result = null;
        if (data != null) {
            double minimum = 0.0;
            int categoryCount = data.getRowCount();
            int item = 0;
            while (item < categoryCount) {
                double total = 0.0;
                int seriesCount = data.getColumnCount();
                int series = 0;
                while (series < seriesCount) {
                    double value;
                    Number number = data.getValue(series, item);
                    if (number != null && (value = number.doubleValue()) < 0.0) {
                        total += value;
                    }
                    ++series;
                }
                minimum = Math.min(minimum, total);
                ++item;
            }
            result = new Double(minimum);
        }
        return result;
    }

    public static Number getMaximumStackedRangeValue(CategoryDataset data) {
        Double result = null;
        if (data != null) {
            double maximum = 0.0;
            int categoryCount = data.getColumnCount();
            int item = 0;
            while (item < categoryCount) {
                double total = 0.0;
                int seriesCount = data.getRowCount();
                int series = 0;
                while (series < seriesCount) {
                    double value;
                    Number number = data.getValue(series, item);
                    if (number != null && (value = number.doubleValue()) > 0.0) {
                        total += value;
                    }
                    ++series;
                }
                maximum = Math.max(maximum, total);
                ++item;
            }
            result = new Double(maximum);
        }
        return result;
    }

    public static XYDataset sampleFunction2D(Function2D f, double start, double end, int samples, String seriesName) {
        if (f == null) {
            throw new IllegalArgumentException("Null 'f' argument.");
        }
        if (seriesName == null) {
            throw new IllegalArgumentException("Null 'seriesName' argument.");
        }
        if (start >= end) {
            throw new IllegalArgumentException("Requires 'start' < 'end'.");
        }
        if (samples < 2) {
            throw new IllegalArgumentException("Requires 'samples' > 1");
        }
        XYSeries series = new XYSeries(seriesName);
        double step = (end - start) / (double)samples;
        int i = 0;
        while (i <= samples) {
            double x = start + step * (double)i;
            series.add(x, f.getValue(x));
            ++i;
        }
        XYSeriesCollection collection = new XYSeriesCollection(series);
        return collection;
    }

    public static CategoryDataset createCategoryDataset(String rowKeyPrefix, String columnKeyPrefix, double[][] data) {
        DefaultCategoryDataset result = new DefaultCategoryDataset();
        int r = 0;
        while (r < data.length) {
            String rowKey = String.valueOf(rowKeyPrefix) + (r + 1);
            int c = 0;
            while (c < data[r].length) {
                String columnKey = String.valueOf(columnKeyPrefix) + (c + 1);
                result.addValue(new Double(data[r][c]), (Comparable)((Object)rowKey), (Comparable)((Object)columnKey));
                ++c;
            }
            ++r;
        }
        return result;
    }

    public static CategoryDataset createCategoryDataset(String rowKeyPrefix, String columnKeyPrefix, Number[][] data) {
        DefaultCategoryDataset result = new DefaultCategoryDataset();
        int r = 0;
        while (r < data.length) {
            String rowKey = String.valueOf(rowKeyPrefix) + (r + 1);
            int c = 0;
            while (c < data[r].length) {
                String columnKey = String.valueOf(columnKeyPrefix) + (c + 1);
                result.addValue(data[r][c], (Comparable)((Object)rowKey), (Comparable)((Object)columnKey));
                ++c;
            }
            ++r;
        }
        return result;
    }

    public static CategoryDataset createCategoryDataset(String[] rowKeys, String[] columnKeys, double[][] data) {
        if (rowKeys == null) {
            throw new IllegalArgumentException("Argument 'rowKeys' cannot be null.");
        }
        if (columnKeys == null) {
            throw new IllegalArgumentException("Argument 'columnKeys' cannot be null.");
        }
        if (rowKeys.length != data.length) {
            throw new IllegalArgumentException("The number of row keys does not match the number of rows in the data array.");
        }
        int columnCount = 0;
        int r = 0;
        while (r < data.length) {
            columnCount = Math.max(columnCount, data[r].length);
            ++r;
        }
        if (columnKeys.length != columnCount) {
            throw new IllegalArgumentException("The number of column keys does not match the number of columns in the data array.");
        }
        DefaultCategoryDataset result = new DefaultCategoryDataset();
        int r2 = 0;
        while (r2 < data.length) {
            String rowKey = rowKeys[r2];
            int c = 0;
            while (c < data[r2].length) {
                String columnKey = columnKeys[c];
                result.addValue(new Double(data[r2][c]), (Comparable)((Object)rowKey), (Comparable)((Object)columnKey));
                ++c;
            }
            ++r2;
        }
        return result;
    }

    public static CategoryDataset createCategoryDataset(String rowKey, KeyedValues rowData) {
        DefaultCategoryDataset result = new DefaultCategoryDataset();
        int i = 0;
        while (i < rowData.getItemCount()) {
            result.addValue(rowData.getValue(i), (Comparable)((Object)rowKey), rowData.getKey(i));
            ++i;
        }
        return result;
    }

    public static boolean isEmptyOrNull(XYDataset data) {
        boolean result = true;
        if (data != null) {
            int s = 0;
            while (s < data.getSeriesCount()) {
                if (data.getItemCount(s) > 0) {
                    result = false;
                }
                ++s;
            }
        }
        return result;
    }

    public static boolean isEmptyOrNull(PieDataset dataset) {
        if (dataset == null) {
            return true;
        }
        int itemCount = dataset.getItemCount();
        if (itemCount == 0) {
            return true;
        }
        int item = 0;
        while (item < itemCount) {
            double yy;
            Number y = dataset.getValue(item);
            if (y != null && (yy = y.doubleValue()) > 0.0) {
                return false;
            }
            ++item;
        }
        return true;
    }

    public static boolean isEmptyOrNull(CategoryDataset data) {
        if (data == null) {
            return true;
        }
        int rowCount = data.getRowCount();
        int columnCount = data.getColumnCount();
        if (rowCount == 0 || columnCount == 0) {
            return true;
        }
        int r = 0;
        while (r < rowCount) {
            int c = 0;
            while (c < columnCount) {
                if (data.getValue(r, c) != null) {
                    return false;
                }
                ++c;
            }
            ++r;
        }
        return true;
    }

    public static PieDataset limitPieDataset(PieDataset dataset, double percentThreshold) {
        return DatasetUtilities.limitPieDataset(dataset, percentThreshold, 2, (Comparable)((Object)"Other"));
    }

    public static PieDataset limitPieDataset(PieDataset dataset, double percentThreshold, int minItems) {
        return DatasetUtilities.limitPieDataset(dataset, percentThreshold, minItems, (Comparable)((Object)"Other"));
    }

    public static PieDataset limitPieDataset(PieDataset dataset, double percentThreshold, int minItems, Comparable key) {
        DefaultPieDataset result = new DefaultPieDataset();
        double total = DatasetUtilities.calculatePieDatasetTotal(dataset);
        List keys = dataset.getKeys();
        ArrayList<Comparable> otherKeys = new ArrayList<Comparable>();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            double value;
            Comparable currentKey = (Comparable)iterator.next();
            Number dataValue = dataset.getValue(currentKey);
            if (dataValue == null || !((value = dataValue.doubleValue()) / total < percentThreshold)) continue;
            otherKeys.add(currentKey);
        }
        iterator = keys.iterator();
        double otherValue = 0.0;
        while (iterator.hasNext()) {
            Comparable currentKey = (Comparable)iterator.next();
            Number dataValue = dataset.getValue(currentKey);
            if (dataValue == null) continue;
            if (otherKeys.contains(currentKey) && otherKeys.size() >= minItems) {
                otherValue += dataValue.doubleValue();
                continue;
            }
            result.setValue(currentKey, dataValue);
        }
        if (otherKeys.size() >= minItems) {
            result.setValue(key, otherValue);
        }
        return result;
    }

    public static Range getStackedRangeExtent(TableXYDataset data) {
        if (data == null) {
            return null;
        }
        double minimum = Double.POSITIVE_INFINITY;
        double maximum = Double.NEGATIVE_INFINITY;
        int itemNo = 0;
        while (itemNo < data.getItemCount()) {
            double value = 0.0;
            int seriesNo = 0;
            while (seriesNo < data.getSeriesCount()) {
                if (data.getYValue(seriesNo, itemNo) != null) {
                    value += data.getYValue(seriesNo, itemNo).doubleValue();
                }
                ++seriesNo;
            }
            if (value > maximum) {
                maximum = value;
            }
            if (value < minimum) {
                minimum = value;
            }
            ++itemNo;
        }
        if (minimum == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(minimum, maximum);
    }

    public static Range getCumulativeRangeExtent(CategoryDataset dataset) {
        if (dataset == null) {
            return null;
        }
        boolean allItemsNull = true;
        double minimum = 0.0;
        double maximum = 0.0;
        int row = 0;
        while (row < dataset.getRowCount()) {
            double runningTotal = 0.0;
            int column = 0;
            while (column < dataset.getColumnCount() - 1) {
                Number n = dataset.getValue(row, column);
                if (n != null) {
                    allItemsNull = false;
                    double value = n.doubleValue();
                    minimum = Math.min(minimum, runningTotal += value);
                    maximum = Math.max(maximum, runningTotal);
                }
                ++column;
            }
            ++row;
        }
        if (!allItemsNull) {
            return new Range(minimum, maximum);
        }
        return null;
    }

    public static Range getDomainExtent(Dataset dataset) {
        return DatasetUtilities.findDomainExtent(dataset);
    }

    public static Range getRangeExtent(Dataset dataset) {
        return DatasetUtilities.findRangeExtent(dataset);
    }
}

