/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import org.jfree.data.DatasetUtilities;
import org.jfree.data.DomainInfo;
import org.jfree.data.Range;
import org.jfree.data.XYDataset;
import org.jfree.util.PublicCloneable;

class IntervalXYDelegate
implements DomainInfo,
Serializable,
Cloneable,
PublicCloneable {
    private static final long serialVersionUID = -685166711639592857L;
    private XYDataset dataset;
    private boolean autoWidth;
    private double intervalPositionFactor;
    private double intervalWidth;
    private double autoIntervalWidth;
    private double lowerBound;
    private double upperBound;

    public IntervalXYDelegate(XYDataset dataset) {
        this(dataset, true);
    }

    public IntervalXYDelegate(XYDataset dataset, boolean autoWidth) {
        this.autoWidth = autoWidth;
        this.dataset = dataset;
        this.intervalPositionFactor = 0.5;
        this.autoWidth = autoWidth;
        this.autoIntervalWidth = Double.POSITIVE_INFINITY;
        this.intervalWidth = 1.0;
    }

    public boolean isAutoWidth() {
        return this.autoWidth;
    }

    public void setAutoWidth(boolean b) {
        this.autoWidth = b;
    }

    public double getIntervalPositionFactor() {
        return this.intervalPositionFactor;
    }

    public void setIntervalPositionFactor(double d) {
        if (d < 0.0 || 1.0 < d) {
            return;
        }
        this.intervalPositionFactor = d;
    }

    public void setIntervalWidth(double d) {
        this.intervalWidth = d;
    }

    public double getIntervalWidth() {
        if (this.isAutoWidth() && !Double.isInfinite(this.autoIntervalWidth)) {
            return this.autoIntervalWidth;
        }
        return this.intervalWidth;
    }

    public Number getStartXValue(int series, int item) {
        Double startX = null;
        Number x = this.dataset.getXValue(series, item);
        if (x != null) {
            startX = new Double(x.doubleValue() - this.getIntervalPositionFactor() * this.getIntervalWidth());
        }
        return startX;
    }

    public Number getEndXValue(int series, int item) {
        Double endX = null;
        Number x = this.dataset.getXValue(series, item);
        if (x != null) {
            endX = new Double(x.doubleValue() + (1.0 - this.getIntervalPositionFactor()) * this.getIntervalWidth());
        }
        return endX;
    }

    public Range getDomainRange() {
        Range range = DatasetUtilities.iterateDomainExtent(this.dataset);
        if (this.dataset.getSeriesCount() == 1 && this.dataset.getItemCount(0) == 1) {
            range = new Range(range.getLowerBound() - this.getIntervalWidth(), range.getUpperBound() + this.getIntervalWidth());
        }
        return range;
    }

    public Number getMaximumDomainValue() {
        return new Double(this.getDomainRange().getUpperBound());
    }

    public Number getMinimumDomainValue() {
        return new Double(this.getDomainRange().getLowerBound());
    }

    public void itemAdded(int series, int item) {
        double after;
        double before;
        double delta;
        double x = this.dataset.getXValue(series, item).doubleValue();
        if (item > 0 && (delta = x - (before = this.dataset.getXValue(series, item - 1).doubleValue())) < this.autoIntervalWidth) {
            this.autoIntervalWidth = delta;
            this.lowerBound = before;
            this.upperBound = x;
        }
        if (item + 1 < this.dataset.getItemCount(series) && (delta = (after = this.dataset.getXValue(series, item + 1).doubleValue()) - x) < this.autoIntervalWidth) {
            this.autoIntervalWidth = delta;
            this.lowerBound = x;
            this.upperBound = after;
        }
    }

    public void itemRemoved(double x) {
        if (x == this.lowerBound || x == this.upperBound) {
            this.recalculateIntervalWidth();
        }
    }

    private void recalculateIntervalWidth() {
        this.autoIntervalWidth = Double.POSITIVE_INFINITY;
        int series = 0;
        int seriesCount = this.dataset.getSeriesCount();
        while (series < seriesCount) {
            this.calculateSeries(series);
            ++series;
        }
    }

    private void calculateSeries(int series) {
        int totalCount = this.dataset.getItemCount(series);
        int item = 1;
        int itemCount = totalCount;
        while (item < itemCount) {
            double lower = this.dataset.getXValue(series, item - 1).doubleValue();
            double upper = this.dataset.getXValue(series, item).doubleValue();
            double delta = upper - lower;
            if (delta < this.autoIntervalWidth) {
                this.autoIntervalWidth = delta;
                this.lowerBound = lower;
                this.upperBound = upper;
            }
            ++item;
        }
    }

    public void seriesAdded(int series) {
        this.calculateSeries(series);
    }

    public void seriesRemoved() {
        this.recalculateIntervalWidth();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

