/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import org.jfree.data.AbstractXYDataset;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.TableXYDataset;
import org.jfree.data.XYDataset;
import org.jfree.util.Log;

public class JDBCXYDataset
extends AbstractXYDataset
implements XYDataset,
TableXYDataset,
RangeInfo {
    private Connection connection;
    private String[] columnNames = new String[0];
    private ArrayList rows = new ArrayList();
    private double maxValue = 0.0;
    private double minValue = 0.0;
    private boolean isTimeSeries = false;

    private JDBCXYDataset() {
    }

    public JDBCXYDataset(String url, String driverName, String user, String password) throws SQLException, ClassNotFoundException {
        this();
        Class.forName(driverName);
        this.connection = DriverManager.getConnection(url, user, password);
    }

    public JDBCXYDataset(Connection con) throws SQLException {
        this();
        this.connection = con;
    }

    public JDBCXYDataset(Connection con, String query) throws SQLException {
        this(con);
        this.executeQuery(query);
    }

    public boolean isTimeSeries() {
        return this.isTimeSeries;
    }

    public void setTimeSeries(boolean timeSeries) {
        this.isTimeSeries = timeSeries;
    }

    public void executeQuery(String query) throws SQLException {
        this.executeQuery(this.connection, query);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeQuery(Connection con, String query) throws SQLException {
        block51: {
            if (con == null) {
                throw new SQLException("There is no database to execute the query.");
            }
            resultSet = null;
            statement = null;
            try {
                block49: {
                    block48: {
                        statement = con.createStatement();
                        resultSet = statement.executeQuery(query);
                        metaData = resultSet.getMetaData();
                        numberOfColumns = metaData.getColumnCount();
                        numberOfValidColumns = 0;
                        columnTypes = new int[numberOfColumns];
                        column = 0;
                        while (true) {
                            if (column >= numberOfColumns) {
                                if (numberOfValidColumns > true) break;
                                throw new SQLException("Not enough valid columns where generated by query.");
                            }
                            try {
                                type = metaData.getColumnType(column + 1);
                                switch (type) {
                                    case -7: 
                                    case -5: 
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 6: 
                                    case 7: 
                                    case 8: 
                                    case 91: 
                                    case 92: 
                                    case 93: {
                                        ++numberOfValidColumns;
                                        columnTypes[column] = type;
                                        break;
                                    }
                                    default: {
                                        Log.warn("Unable to load column " + column + " (" + type + "," + metaData.getColumnClassName(column + 1) + ")");
                                        columnTypes[column] = 0;
                                        break;
                                    }
                                }
                            }
                            catch (SQLException e) {
                                columnTypes[column] = 0;
                                throw e;
                            }
                            ++column;
                        }
                        this.columnNames = new String[numberOfValidColumns - 1];
                        currentColumn = 0;
                        column = 1;
                        while (true) {
                            if (column >= numberOfColumns) {
                                if (this.rows != null) {
                                    break;
                                }
                                break block48;
                            }
                            if (columnTypes[column] != 0) {
                                this.columnNames[currentColumn] = metaData.getColumnLabel(column + 1);
                                ++currentColumn;
                            }
                            ++column;
                        }
                        column = 0;
                        while (true) {
                            if (column >= this.rows.size()) {
                                this.rows.clear();
                                break;
                            }
                            row = (ArrayList)this.rows.get(column);
                            row.clear();
                            ++column;
                        }
                    }
                    switch (columnTypes[0]) {
                        case 91: 
                        case 92: 
                        case 93: {
                            this.isTimeSeries = true;
                            ** break;
                        }
                    }
                    this.isTimeSeries = false;
                    ** break;
lbl63:
                    // 2 sources

                    block25: while (true) {
                        if (!resultSet.next()) {
                            if (this.rows.size() == 0) {
                                break;
                            }
                            break block49;
                        }
                        newRow = new ArrayList<Object>();
                        column = 0;
                        while (true) {
                            if (column >= numberOfColumns) {
                                this.rows.add(newRow);
                                continue block25;
                            }
                            xObject = resultSet.getObject(column + 1);
                            switch (columnTypes[column]) {
                                case -5: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: {
                                    newRow.add(xObject);
                                    break;
                                }
                                case 91: 
                                case 92: 
                                case 93: {
                                    newRow.add(new Long(((Date)xObject).getTime()));
                                    break;
                                }
                                case 0: {
                                    break;
                                }
                                default: {
                                    System.err.println("Unknown data");
                                    columnTypes[column] = 0;
                                }
                            }
                            ++column;
                        }
                        break;
                    }
                    newRow = new ArrayList<Integer>();
                    column = 0;
                    while (true) {
                        if (column >= numberOfColumns) {
                            this.rows.add(newRow);
                            break;
                        }
                        if (columnTypes[column] != 0) {
                            newRow.add(new Integer(0));
                        }
                        ++column;
                    }
                }
                if (this.rows.size() < 1) {
                    this.maxValue = 0.0;
                    this.minValue = 0.0;
                } else {
                    row = (ArrayList)this.rows.get(0);
                    this.maxValue = -Infinity;
                    this.minValue = Infinity;
                    rowNum = 0;
                    block28: while (rowNum < this.rows.size()) {
                        row = (ArrayList)this.rows.get(rowNum);
                        column = 1;
                        while (true) {
                            if (column >= numberOfColumns) {
                                ++rowNum;
                                continue block28;
                            }
                            testValue = row.get(column);
                            if (testValue != null) {
                                test = ((Number)testValue).doubleValue();
                                if (test < this.minValue) {
                                    this.minValue = test;
                                }
                                if (test > this.maxValue) {
                                    this.maxValue = test;
                                }
                            }
                            ++column;
                        }
                    }
                }
                this.fireDatasetChanged();
            }
            catch (Throwable var17_23) {
                var16_24 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception var18_26) {
                        // empty catch block
                    }
                }
                if (statement == null) throw var17_23;
                try {
                    statement.close();
                    throw var17_23;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw var17_23;
            }
            {
                var16_25 = null;
                if (resultSet == null) break block51;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 927->936)] { 
lbl151:
            // 1 sources

            resultSet.close();
            break block51;
lbl153:
            // 1 sources

            catch (Exception var18_27) {
                // empty catch block
            }
        }
        if (statement == null) return;
        try {}
        catch (Exception e) {
            return;
        }
        statement.close();
    }

    public Number getXValue(int seriesIndex, int itemIndex) {
        ArrayList row = (ArrayList)this.rows.get(itemIndex);
        return (Number)row.get(0);
    }

    public Number getYValue(int seriesIndex, int itemIndex) {
        ArrayList row = (ArrayList)this.rows.get(itemIndex);
        return (Number)row.get(seriesIndex + 1);
    }

    public int getItemCount(int seriesIndex) {
        return this.rows.size();
    }

    public int getItemCount() {
        return this.getItemCount(0);
    }

    public int getSeriesCount() {
        return this.columnNames.length;
    }

    public String getSeriesName(int seriesIndex) {
        if (seriesIndex < this.columnNames.length && this.columnNames[seriesIndex] != null) {
            return this.columnNames[seriesIndex];
        }
        return "";
    }

    public int getLegendItemCount() {
        return this.getSeriesCount();
    }

    public String[] getLegendItemLabels() {
        return this.columnNames;
    }

    public Number getMinimumRangeValue() {
        return new Double(this.minValue);
    }

    public Number getMaximumRangeValue() {
        return new Double(this.maxValue);
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (Exception e) {
            System.err.println("JdbcXYDataset: swallowing exception.");
        }
    }

    public Range getValueRange() {
        return new Range(this.minValue, this.maxValue);
    }
}

