/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import org.jfree.data.XYDataset;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;

public class MovingAverage {
    public static TimeSeriesCollection createMovingAverage(TimeSeriesCollection source, String suffix, int periodCount, int skip) {
        if (source == null) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage(...) : null source.");
        }
        if (periodCount < 1) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage(...) : periodCount must be greater than or equal to 1.");
        }
        TimeSeriesCollection result = new TimeSeriesCollection();
        int i = 0;
        while (i < source.getSeriesCount()) {
            TimeSeries sourceSeries = source.getSeries(i);
            TimeSeries maSeries = MovingAverage.createMovingAverage(sourceSeries, String.valueOf(sourceSeries.getName()) + suffix, periodCount, skip);
            result.addSeries(maSeries);
            ++i;
        }
        return result;
    }

    public static TimeSeries createMovingAverage(TimeSeries source, String name, int periodCount, int skip) {
        if (source == null) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage(...) : null source.");
        }
        if (periodCount < 1) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage(...) : periodCount must be greater than or equal to 1.");
        }
        TimeSeries result = new TimeSeries(name, source.getTimePeriodClass());
        if (source.getItemCount() > 0) {
            long firstSerial = source.getDataItem(0).getPeriod().getSerialIndex() + (long)skip;
            int i = source.getItemCount() - 1;
            while (i >= 0) {
                TimeSeriesDataItem current = source.getDataItem(i);
                RegularTimePeriod period = current.getPeriod();
                long serial = period.getSerialIndex();
                if (serial >= firstSerial) {
                    int n = 0;
                    double sum = 0.0;
                    long serialLimit = period.getSerialIndex() - (long)periodCount;
                    int offset = 0;
                    boolean finished = false;
                    while (offset < periodCount && !finished) {
                        if (i - offset >= 0) {
                            TimeSeriesDataItem item = source.getDataItem(i - offset);
                            RegularTimePeriod p = item.getPeriod();
                            Number v = item.getValue();
                            long currentIndex = p.getSerialIndex();
                            if (currentIndex > serialLimit) {
                                if (v != null) {
                                    sum += v.doubleValue();
                                    ++n;
                                }
                            } else {
                                finished = true;
                            }
                        }
                        ++offset;
                    }
                    if (n > 0) {
                        result.add(period, sum / (double)n);
                    } else {
                        result.add(period, null);
                    }
                }
                --i;
            }
        }
        return result;
    }

    public static TimeSeries createPointMovingAverage(TimeSeries source, String name, int pointCount) {
        if (source == null) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage(...) : null source.");
        }
        if (pointCount < 2) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage(...) : periodCount must be greater than or equal to 2.");
        }
        TimeSeries result = new TimeSeries(name, source.getTimePeriodClass());
        double rollingSumForPeriod = 0.0;
        int i = 0;
        while (i < source.getItemCount()) {
            TimeSeriesDataItem current = source.getDataItem(i);
            RegularTimePeriod period = current.getPeriod();
            rollingSumForPeriod += current.getValue().doubleValue();
            if (i > pointCount - 1) {
                TimeSeriesDataItem startOfMovingAvg = source.getDataItem(i - pointCount);
                result.add(period, (rollingSumForPeriod -= startOfMovingAvg.getValue().doubleValue()) / (double)pointCount);
            } else if (i == pointCount - 1) {
                result.add(period, rollingSumForPeriod / (double)pointCount);
            }
            ++i;
        }
        return result;
    }

    public static XYDataset createMovingAverage(XYDataset source, String suffix, long period, long skip) {
        return MovingAverage.createMovingAverage(source, suffix, (double)period, (double)skip);
    }

    public static XYDataset createMovingAverage(XYDataset source, String suffix, double period, double skip) {
        if (source == null) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage(...) : null source (XYDataset).");
        }
        XYSeriesCollection result = new XYSeriesCollection();
        int i = 0;
        while (i < source.getSeriesCount()) {
            XYSeries s = MovingAverage.createMovingAverage(source, i, String.valueOf(source.getSeriesName(i)) + suffix, period, skip);
            result.addSeries(s);
            ++i;
        }
        return result;
    }

    public static XYSeries createMovingAverage(XYDataset source, int series, String name, long period, long skip) {
        return MovingAverage.createMovingAverage(source, series, name, (double)period, (double)skip);
    }

    public static XYSeries createMovingAverage(XYDataset source, int series, String name, double period, double skip) {
        if (source == null) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage(...) : null source (XYDataset).");
        }
        if (period < Double.MIN_VALUE) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage(...) : period must be positive.");
        }
        if (skip < 0.0) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage(...) : skip must be >= 0.0.");
        }
        XYSeries result = new XYSeries(name);
        if (source.getItemCount(series) > 0) {
            double first = source.getXValue(series, 0).doubleValue() + skip;
            int i = source.getItemCount(series) - 1;
            while (i >= 0) {
                double x = source.getXValue(series, i).doubleValue();
                if (x >= first) {
                    int n = 0;
                    double sum = 0.0;
                    double limit = x - period;
                    int offset = 0;
                    boolean finished = false;
                    while (!finished) {
                        if (i - offset >= 0) {
                            double xx = source.getXValue(series, i - offset).doubleValue();
                            Number yy = source.getYValue(series, i - offset);
                            if (xx > limit) {
                                if (yy != null) {
                                    sum += yy.doubleValue();
                                    ++n;
                                }
                            } else {
                                finished = true;
                            }
                        } else {
                            finished = true;
                        }
                        ++offset;
                    }
                    if (n > 0) {
                        result.add(x, sum / (double)n);
                    } else {
                        result.add(x, (Number)null);
                    }
                }
                --i;
            }
        }
        return result;
    }
}

