/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.swing.event.EventListenerList;
import org.jfree.data.SeriesChangeEvent;
import org.jfree.data.SeriesChangeListener;
import org.jfree.util.ObjectUtils;

public class Series
implements Cloneable,
Serializable {
    private String name;
    private String description;
    private EventListenerList listeners;
    private PropertyChangeSupport propertyChangeSupport;
    private boolean notify;
    static /* synthetic */ Class class$0;

    protected Series(String name) {
        this(name, null);
    }

    protected Series(String name, String description) {
        if (name == null) {
            throw new IllegalArgumentException("Null 'name' argument.");
        }
        this.name = name;
        this.description = description;
        this.listeners = new EventListenerList();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.notify = true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null 'name' argument.");
        }
        String old = this.name;
        this.name = name;
        this.propertyChangeSupport.firePropertyChange("Name", old, name);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        String old = this.description;
        this.description = description;
        this.propertyChangeSupport.firePropertyChange("Description", old, description);
    }

    public boolean getNotify() {
        return this.notify;
    }

    public void setNotify(boolean notify) {
        if (this.notify != notify) {
            this.notify = notify;
            this.fireSeriesChanged();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            Series clone = (Series)super.clone();
            clone.listeners = new EventListenerList();
            clone.propertyChangeSupport = new PropertyChangeSupport(clone);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new CloneNotSupportedException("Series.clone(): unexpected exception.");
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Series)) {
            return false;
        }
        Series s = (Series)object;
        if (!this.getName().equals(s.getName())) {
            return false;
        }
        return ObjectUtils.equal(this.getDescription(), s.getDescription());
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 29 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    public void addChangeListener(SeriesChangeListener listener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.SeriesChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listeners.add(clazz, listener);
    }

    public void removeChangeListener(SeriesChangeListener listener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.SeriesChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listeners.remove(clazz, listener);
    }

    public void fireSeriesChanged() {
        if (this.notify) {
            this.notifyListeners(new SeriesChangeEvent(this));
        }
    }

    protected void notifyListeners(SeriesChangeEvent event) {
        Object[] listenerList = this.listeners.getListenerList();
        int i = listenerList.length - 2;
        while (i >= 0) {
            Object object = listenerList[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.jfree.data.SeriesChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                ((SeriesChangeListener)listenerList[i + 1]).seriesChanged(event);
            }
            i -= 2;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(property, oldValue, newValue);
    }
}

