/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jfree.data.DatasetChangeEvent;
import org.jfree.data.DatasetChangeListener;
import org.jfree.data.XYDataset;

public class XYDatasetTableModel
extends AbstractTableModel
implements TableModel,
DatasetChangeListener {
    XYDataset model = null;

    public XYDatasetTableModel() {
    }

    public XYDatasetTableModel(XYDataset dataset) {
        this();
        this.setModel(dataset);
    }

    public void setModel(XYDataset dataset) {
        this.model = dataset;
        this.model.addChangeListener(this);
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        if (this.model == null) {
            return 0;
        }
        return this.model.getItemCount(0);
    }

    public int getColumnCount() {
        if (this.model == null) {
            return 0;
        }
        return this.model.getSeriesCount() + 1;
    }

    public String getColumnName(int column) {
        if (this.model == null) {
            return super.getColumnName(column);
        }
        if (column < 1) {
            return "X Value";
        }
        return this.model.getSeriesName(column - 1);
    }

    public Object getValueAt(int row, int column) {
        if (this.model == null) {
            return null;
        }
        if (column < 1) {
            return this.model.getXValue(0, row);
        }
        return this.model.getYValue(row, column - 1);
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        this.fireTableDataChanged();
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void setValueAt(Object value, int row, int column) {
        this.isCellEditable(row, column);
    }
}

