/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.data.AbstractIntervalXYDataset;
import org.jfree.data.DomainInfo;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.IntervalXYDelegate;
import org.jfree.data.Range;
import org.jfree.data.XYDataItem;
import org.jfree.data.XYSeries;
import org.jfree.util.ObjectUtils;

public class XYSeriesCollection
extends AbstractIntervalXYDataset
implements IntervalXYDataset,
DomainInfo,
Serializable {
    private List data = new ArrayList();
    private IntervalXYDelegate intervalDelegate = new IntervalXYDelegate(this, false);

    public XYSeriesCollection() {
        this(null);
    }

    public XYSeriesCollection(XYSeries series) {
        if (series != null) {
            this.data.add(series);
            series.addChangeListener(this);
        }
    }

    public double getIntervalWidth() {
        return this.intervalDelegate.getIntervalWidth();
    }

    public void setIntervalWidth(double width) {
        this.intervalDelegate.setIntervalWidth(width);
        this.fireDatasetChanged();
    }

    public double getIntervalPositionFactor() {
        return this.intervalDelegate.getIntervalPositionFactor();
    }

    public void setIntervalPositionFactor(double factor) {
        this.intervalDelegate.setIntervalPositionFactor(factor);
        this.fireDatasetChanged();
    }

    public boolean isAutoWidth() {
        return this.intervalDelegate.isAutoWidth();
    }

    public void setAutoWidth(boolean b) {
        this.intervalDelegate.setAutoWidth(b);
        this.fireDatasetChanged();
    }

    public void addSeries(XYSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("XYSeriesCollection.addSeries(...): cannot add null series.");
        }
        this.data.add(series);
        this.intervalDelegate.seriesAdded(this.data.size() - 1);
        series.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public List getSeries() {
        return Collections.unmodifiableList(this.data);
    }

    public XYSeries getSeries(int series) {
        if (series < 0 || series > this.getSeriesCount()) {
            throw new IllegalArgumentException("XYSeriesCollection.getSeries(...): index outside valid range.");
        }
        XYSeries ts = (XYSeries)this.data.get(series);
        return ts;
    }

    public String getSeriesName(int series) {
        return this.getSeries(series).getName();
    }

    public int getItemCount(int series) {
        return this.getSeries(series).getItemCount();
    }

    public Number getXValue(int series, int item) {
        XYSeries ts = (XYSeries)this.data.get(series);
        XYDataItem xyItem = ts.getDataItem(item);
        return xyItem.getX();
    }

    public Number getStartXValue(int series, int item) {
        return this.intervalDelegate.getStartXValue(series, item);
    }

    public Number getEndXValue(int series, int item) {
        return this.intervalDelegate.getEndXValue(series, item);
    }

    public Number getYValue(int series, int index) {
        XYSeries ts = (XYSeries)this.data.get(series);
        XYDataItem xyItem = ts.getDataItem(index);
        return xyItem.getY();
    }

    public Number getStartYValue(int series, int item) {
        return this.getYValue(series, item);
    }

    public Number getEndYValue(int series, int item) {
        return this.getYValue(series, item);
    }

    public void removeAllSeries() {
        int i = 0;
        while (i < this.data.size()) {
            XYSeries series = (XYSeries)this.data.get(i);
            series.removeChangeListener(this);
            ++i;
        }
        this.data.clear();
        this.intervalDelegate.seriesRemoved();
        this.fireDatasetChanged();
    }

    public void removeSeries(XYSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("XYSeriesCollection.removeSeries(...): cannot remove null series.");
        }
        if (this.data.contains(series)) {
            series.removeChangeListener(this);
            this.data.remove(series);
            this.intervalDelegate.seriesRemoved();
            this.fireDatasetChanged();
        }
    }

    public void removeSeries(int series) {
        if (series < 0 || series > this.getSeriesCount()) {
            throw new IllegalArgumentException("XYSeriesCollection.removeSeries(...): index outside valid range.");
        }
        XYSeries ts = (XYSeries)this.data.get(series);
        ts.removeChangeListener(this);
        this.data.remove(series);
        this.intervalDelegate.seriesRemoved();
        this.fireDatasetChanged();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof XYSeriesCollection) {
            XYSeriesCollection c = (XYSeriesCollection)obj;
            return ObjectUtils.equal(this.data, c.data);
        }
        return false;
    }

    public int hashCode() {
        return this.data != null ? this.data.hashCode() : 0;
    }

    public Range getDomainRange() {
        return this.intervalDelegate.getDomainRange();
    }

    public Number getMaximumDomainValue() {
        return this.intervalDelegate.getMaximumDomainValue();
    }

    public Number getMinimumDomainValue() {
        return this.intervalDelegate.getMinimumDomainValue();
    }
}

