/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DatasetUtilities;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.data.KeyToGroupMap;
import org.jfree.data.Range;
import org.jfree.data.XYDataset;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;
import org.jfree.util.NumberUtils;

public class DatasetUtilitiesTests
extends TestCase {
    private static final double DELTA = 1.0E-7;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.junit.DatasetUtilitiesTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public DatasetUtilitiesTests(String name) {
        super(name);
    }

    public void testJava() {
        Assert.assertTrue((boolean)Double.isNaN(Math.min(1.0, Double.NaN)));
        Assert.assertTrue((boolean)Double.isNaN(Math.max(1.0, Double.NaN)));
    }

    public void testFindDomainExtent() {
        XYDataset dataset = this.createXYDataset1();
        Range r = DatasetUtilities.findDomainExtent(dataset);
        Assert.assertEquals((double)1.0, (double)r.getLowerBound(), (double)1.0E-7);
        Assert.assertEquals((double)3.0, (double)r.getUpperBound(), (double)1.0E-7);
    }

    public void testIterateDomainExtent() {
        XYDataset dataset = this.createXYDataset1();
        Range r = DatasetUtilities.iterateDomainExtent(dataset);
        Assert.assertEquals((double)1.0, (double)r.getLowerBound(), (double)1.0E-7);
        Assert.assertEquals((double)3.0, (double)r.getUpperBound(), (double)1.0E-7);
    }

    public void testFindRangeExtent() {
        XYDataset dataset = this.createXYDataset1();
        Range r = DatasetUtilities.findRangeExtent(dataset);
        Assert.assertEquals((double)100.0, (double)r.getLowerBound(), (double)1.0E-7);
        Assert.assertEquals((double)105.0, (double)r.getUpperBound(), (double)1.0E-7);
    }

    public void testIterateCategoryRangeExtent() {
        CategoryDataset dataset = this.createCategoryDataset1();
        Range r = DatasetUtilities.iterateCategoryRangeExtent(dataset);
        Assert.assertEquals((double)1.0, (double)r.getLowerBound(), (double)1.0E-7);
        Assert.assertEquals((double)6.0, (double)r.getUpperBound(), (double)1.0E-7);
    }

    public void testIterateXYRangeExtent() {
        XYDataset dataset = this.createXYDataset1();
        Range r = DatasetUtilities.iterateXYRangeExtent(dataset);
        Assert.assertEquals((double)100.0, (double)r.getLowerBound(), (double)1.0E-7);
        Assert.assertEquals((double)105.0, (double)r.getUpperBound(), (double)1.0E-7);
    }

    public void testMinMaxRange() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(100.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 1"));
        dataset.addValue(101.1, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 2"));
        Number min = DatasetUtilities.getMinimumRangeValue(dataset);
        Assert.assertTrue((min.doubleValue() < 100.1 ? 1 : 0) != 0);
        Number max = DatasetUtilities.getMaximumRangeValue(dataset);
        Assert.assertTrue((max.doubleValue() > 101.0 ? 1 : 0) != 0);
    }

    public void test803660() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(100.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 1"));
        dataset.addValue(101.1, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 2"));
        Number n = DatasetUtilities.getMaximumRangeValue(dataset);
        Assert.assertTrue((n.doubleValue() > 101.0 ? 1 : 0) != 0);
    }

    public void testCumulativeRange1() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(10.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Start"));
        dataset.addValue(15.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 1"));
        dataset.addValue(-7.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 2"));
        Range range = DatasetUtilities.getCumulativeRangeExtent(dataset);
        Assert.assertTrue((boolean)NumberUtils.equal(range.getLowerBound(), 0.0));
        Assert.assertTrue((boolean)NumberUtils.equal(range.getUpperBound(), 25.0));
    }

    public void testCumulativeRange2() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(-21.4, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Start Value"));
        dataset.addValue(11.57, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 1"));
        dataset.addValue(3.51, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 2"));
        dataset.addValue(-12.36, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 3"));
        dataset.addValue(3.39, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 4"));
        dataset.addValue(38.68, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 5"));
        dataset.addValue(-43.31, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 6"));
        dataset.addValue(-29.59, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 7"));
        dataset.addValue(35.3, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 8"));
        dataset.addValue(5.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 9"));
        Range range = DatasetUtilities.getCumulativeRangeExtent(dataset);
        Assert.assertTrue((boolean)NumberUtils.equal(range.getLowerBound(), -49.51));
        Assert.assertTrue((boolean)NumberUtils.equal(range.getUpperBound(), 23.39));
    }

    public void testCreateCategoryDataset1() {
        String[] rowKeys = new String[]{"R1", "R2", "R3"};
        String[] columnKeys = new String[]{"C1", "C2"};
        double[][] data = new double[][]{{1.1, 1.2}, {2.1, 2.2}, {3.1, 3.2}};
        CategoryDataset dataset = DatasetUtilities.createCategoryDataset(rowKeys, columnKeys, data);
        Assert.assertTrue((dataset.getRowCount() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((dataset.getColumnCount() == 2 ? 1 : 0) != 0);
    }

    public void testCreateCategoryDataset2() {
        boolean pass = false;
        String[] rowKeys = new String[]{"R1", "R2", "R3"};
        String[] columnKeys = new String[]{"C1", "C2"};
        double[][] data = new double[][]{{1.1, 1.2, 1.3}, {2.1, 2.2, 2.3}};
        CategoryDataset dataset = null;
        try {
            dataset = DatasetUtilities.createCategoryDataset(rowKeys, columnKeys, data);
        }
        catch (IllegalArgumentException e) {
            pass = true;
        }
        Assert.assertTrue((boolean)pass);
        Assert.assertTrue((dataset == null ? 1 : 0) != 0);
    }

    public void testMaximumStackedRangeValue() {
        double v1 = 24.3;
        double v2 = 14.2;
        double v3 = 33.2;
        double v4 = 32.4;
        double v5 = 26.3;
        double v6 = 22.6;
        Double answer = new Double(Math.max(71.7, 81.30000000000001));
        DefaultCategoryDataset d = new DefaultCategoryDataset();
        d.addValue(24.3, (Comparable)((Object)"Row 0"), (Comparable)((Object)"Column 0"));
        d.addValue(14.2, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 0"));
        d.addValue(33.2, (Comparable)((Object)"Row 2"), (Comparable)((Object)"Column 0"));
        d.addValue(32.4, (Comparable)((Object)"Row 0"), (Comparable)((Object)"Column 1"));
        d.addValue(26.3, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 1"));
        d.addValue(22.6, (Comparable)((Object)"Row 2"), (Comparable)((Object)"Column 1"));
        Number max = DatasetUtilities.getMaximumStackedRangeValue(d);
        Assert.assertTrue((boolean)max.equals(answer));
    }

    public void testStackedRange() {
        CategoryDataset d = this.createCategoryDataset1();
        Range r = DatasetUtilities.getStackedRangeExtent(d);
        Assert.assertEquals((double)0.0, (double)r.getLowerBound(), (double)1.0E-6);
        Assert.assertEquals((double)15.0, (double)r.getUpperBound(), (double)1.0E-6);
    }

    public void testStackedRangeWithMap() {
        CategoryDataset d = this.createCategoryDataset1();
        KeyToGroupMap map = new KeyToGroupMap((Comparable)((Object)"G0"));
        map.mapKeyToGroup((Comparable)((Object)"R2"), (Comparable)((Object)"G1"));
        Range r = DatasetUtilities.getStackedRangeExtent(d, map);
        Assert.assertEquals((double)0.0, (double)r.getLowerBound(), (double)1.0E-6);
        Assert.assertEquals((double)9.0, (double)r.getUpperBound(), (double)1.0E-6);
    }

    private CategoryDataset createCategoryDataset1() {
        DefaultCategoryDataset result = new DefaultCategoryDataset();
        result.addValue(1.0, (Comparable)((Object)"R0"), (Comparable)((Object)"C0"));
        result.addValue(1.0, (Comparable)((Object)"R1"), (Comparable)((Object)"C0"));
        result.addValue(1.0, (Comparable)((Object)"R2"), (Comparable)((Object)"C0"));
        result.addValue(4.0, (Comparable)((Object)"R0"), (Comparable)((Object)"C1"));
        result.addValue(5.0, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        result.addValue(6.0, (Comparable)((Object)"R2"), (Comparable)((Object)"C1"));
        return result;
    }

    private XYDataset createXYDataset1() {
        XYSeries series1 = new XYSeries("S1");
        series1.add(1.0, 100.0);
        series1.add(2.0, 101.0);
        series1.add(3.0, 102.0);
        XYSeries series2 = new XYSeries("S2");
        series2.add(1.0, 103.0);
        series2.add(2.0, 104.0);
        series2.add(3.0, 105.0);
        XYSeriesCollection result = new XYSeriesCollection();
        result.addSeries(series1);
        result.addSeries(series2);
        result.setIntervalWidth(0.0);
        return result;
    }
}

