/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.DefaultCategoryDataset;

public class DefaultCategoryDatasetTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.junit.DefaultCategoryDatasetTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public DefaultCategoryDatasetTests(String name) {
        super(name);
    }

    public void testEquals() {
        DefaultCategoryDataset d1 = new DefaultCategoryDataset();
        d1.setValue(23.4, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        DefaultCategoryDataset d2 = new DefaultCategoryDataset();
        d2.setValue(23.4, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        Assert.assertTrue((boolean)d1.equals(d2));
        Assert.assertTrue((boolean)d2.equals(d1));
        d1.setValue(36.5, (Comparable)((Object)"R1"), (Comparable)((Object)"C2"));
        Assert.assertFalse((boolean)d1.equals(d2));
        d2.setValue(36.5, (Comparable)((Object)"R1"), (Comparable)((Object)"C2"));
        Assert.assertTrue((boolean)d1.equals(d2));
        d1.setValue(null, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        Assert.assertFalse((boolean)d1.equals(d2));
        d2.setValue(null, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        Assert.assertTrue((boolean)d1.equals(d2));
    }

    public void testSerialization() {
        DefaultCategoryDataset d1 = new DefaultCategoryDataset();
        d1.setValue(23.4, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        DefaultCategoryDataset d2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(d1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            d2 = (DefaultCategoryDataset)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)d1, d2);
    }
}

