/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.DefaultKeyedValueDataset;

public class DefaultKeyedValueDatasetTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.junit.DefaultKeyedValueDatasetTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public DefaultKeyedValueDatasetTests(String name) {
        super(name);
    }

    public void testEquals() {
        DefaultKeyedValueDataset d1 = new DefaultKeyedValueDataset((Comparable)((Object)"Test"), new Double(45.5));
        DefaultKeyedValueDataset d2 = new DefaultKeyedValueDataset((Comparable)((Object)"Test"), new Double(45.5));
        Assert.assertTrue((boolean)d1.equals(d2));
        Assert.assertTrue((boolean)d2.equals(d1));
        d1 = new DefaultKeyedValueDataset((Comparable)((Object)"Test 1"), new Double(45.5));
        d2 = new DefaultKeyedValueDataset((Comparable)((Object)"Test 2"), new Double(45.5));
        Assert.assertFalse((boolean)d1.equals(d2));
        d1 = new DefaultKeyedValueDataset((Comparable)((Object)"Test"), new Double(45.5));
        d2 = new DefaultKeyedValueDataset((Comparable)((Object)"Test"), new Double(45.6));
        Assert.assertFalse((boolean)d1.equals(d2));
    }

    public void testCloning() {
        DefaultKeyedValueDataset d1 = new DefaultKeyedValueDataset((Comparable)((Object)"Test"), new Double(45.5));
        DefaultKeyedValueDataset d2 = null;
        try {
            d2 = (DefaultKeyedValueDataset)d1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("DefaultKeyedValueDatasetTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((d1 != d2 ? 1 : 0) != 0);
        Assert.assertTrue((d1.getClass() == d2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)d1.equals(d2));
    }

    public void testCloneIndependence() {
        DefaultKeyedValueDataset d1 = new DefaultKeyedValueDataset((Comparable)((Object)"Key"), new Double(10.0));
        DefaultKeyedValueDataset d2 = null;
        try {
            d2 = (DefaultKeyedValueDataset)d1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("DefaultKeyedValueDatasetTests.testCloneIndependence: failed to clone.");
        }
        Assert.assertTrue((boolean)d1.equals(d2));
        d2.updateValue(new Double(99.9));
        Assert.assertFalse((boolean)d1.equals(d2));
        d2.updateValue(new Double(10.0));
        Assert.assertTrue((boolean)d1.equals(d2));
    }

    public void testSerialization() {
        DefaultKeyedValueDataset d1 = new DefaultKeyedValueDataset((Comparable)((Object)"Test"), new Double(25.3));
        DefaultKeyedValueDataset d2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(d1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            d2 = (DefaultKeyedValueDataset)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)d1, d2);
    }
}

