/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.DefaultKeyedValue;

public class DefaultKeyedValueTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.junit.DefaultKeyedValueTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public DefaultKeyedValueTests(String name) {
        super(name);
    }

    public void testEquals() {
        DefaultKeyedValue v1 = new DefaultKeyedValue((Comparable)((Object)"Test"), new Double(45.5));
        DefaultKeyedValue v2 = new DefaultKeyedValue((Comparable)((Object)"Test"), new Double(45.5));
        Assert.assertTrue((boolean)v1.equals(v2));
        Assert.assertTrue((boolean)v2.equals(v1));
        v1 = new DefaultKeyedValue((Comparable)((Object)"Test 1"), new Double(45.5));
        v2 = new DefaultKeyedValue((Comparable)((Object)"Test 2"), new Double(45.5));
        Assert.assertFalse((boolean)v1.equals(v2));
        v1 = new DefaultKeyedValue((Comparable)((Object)"Test"), new Double(45.5));
        v2 = new DefaultKeyedValue((Comparable)((Object)"Test"), new Double(45.6));
        Assert.assertFalse((boolean)v1.equals(v2));
    }

    public void testCloning() {
        DefaultKeyedValue v1 = new DefaultKeyedValue((Comparable)((Object)"Test"), new Double(45.5));
        DefaultKeyedValue v2 = null;
        try {
            v2 = (DefaultKeyedValue)v1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("DefaultKeyedValueTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((v1 != v2 ? 1 : 0) != 0);
        Assert.assertTrue((v1.getClass() == v2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)v1.equals(v2));
    }

    public void testSerialization() {
        DefaultKeyedValue v1 = new DefaultKeyedValue((Comparable)((Object)"Test"), new Double(25.3));
        DefaultKeyedValue v2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(v1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            v2 = (DefaultKeyedValue)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)v1, v2);
    }
}

