/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.DefaultKeyedValues2DDataset;

public class DefaultKeyedValues2DDatasetTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.junit.DefaultKeyedValues2DDatasetTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public DefaultKeyedValues2DDatasetTests(String name) {
        super(name);
    }

    public void testCloning() {
        DefaultKeyedValues2DDataset d1 = new DefaultKeyedValues2DDataset();
        d1.setValue(new Integer(1), (Comparable)((Object)"V1"), (Comparable)((Object)"C1"));
        d1.setValue(null, (Comparable)((Object)"V2"), (Comparable)((Object)"C1"));
        d1.setValue(new Integer(3), (Comparable)((Object)"V3"), (Comparable)((Object)"C2"));
        DefaultKeyedValues2DDataset d2 = null;
        try {
            d2 = (DefaultKeyedValues2DDataset)d1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("DefaultKeyedValues2DDatasetTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((d1 != d2 ? 1 : 0) != 0);
        Assert.assertTrue((d1.getClass() == d2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)d1.equals(d2));
    }

    public void testSerialization() {
        DefaultKeyedValues2DDataset d1 = new DefaultKeyedValues2DDataset();
        d1.addValue(new Double(234.2), (Comparable)((Object)"Row1"), (Comparable)((Object)"Col1"));
        d1.addValue(null, (Comparable)((Object)"Row1"), (Comparable)((Object)"Col2"));
        d1.addValue(new Double(345.9), (Comparable)((Object)"Row2"), (Comparable)((Object)"Col1"));
        d1.addValue(new Double(452.7), (Comparable)((Object)"Row2"), (Comparable)((Object)"Col2"));
        DefaultKeyedValues2DDataset d2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(d1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            d2 = (DefaultKeyedValues2DDataset)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)d1, d2);
    }
}

