/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.DefaultKeyedValuesDataset;
import org.jfree.data.KeyedValuesDataset;

public class DefaultKeyedValuesDatasetTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.junit.DefaultKeyedValuesDatasetTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public DefaultKeyedValuesDatasetTests(String name) {
        super(name);
    }

    public void testCloning() {
        DefaultKeyedValuesDataset d1 = new DefaultKeyedValuesDataset();
        d1.setValue((Comparable)((Object)"V1"), new Integer(1));
        d1.setValue((Comparable)((Object)"V2"), null);
        d1.setValue((Comparable)((Object)"V3"), new Integer(3));
        DefaultKeyedValuesDataset d2 = null;
        try {
            d2 = (DefaultKeyedValuesDataset)d1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("DefaultKeyedValuesDatasetTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((d1 != d2 ? 1 : 0) != 0);
        Assert.assertTrue((d1.getClass() == d2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)d1.equals(d2));
    }

    public void testSerialization() {
        DefaultKeyedValuesDataset d1 = new DefaultKeyedValuesDataset();
        d1.setValue((Comparable)((Object)"C1"), new Double(234.2));
        d1.setValue((Comparable)((Object)"C2"), null);
        d1.setValue((Comparable)((Object)"C3"), new Double(345.9));
        d1.setValue((Comparable)((Object)"C4"), new Double(452.7));
        KeyedValuesDataset d2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(d1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            d2 = (KeyedValuesDataset)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)d1, d2);
    }
}

