/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.util.SortOrder;

public class DefaultKeyedValuesTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.junit.DefaultKeyedValuesTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public DefaultKeyedValuesTests(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testCloning() {
        DefaultKeyedValues v1 = new DefaultKeyedValues();
        v1.addValue((Comparable)((Object)"V1"), new Integer(1));
        v1.addValue((Comparable)((Object)"V2"), null);
        v1.addValue((Comparable)((Object)"V3"), new Integer(3));
        DefaultKeyedValues v2 = null;
        try {
            v2 = (DefaultKeyedValues)v1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("DefaultKeyedValuesTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((v1 != v2 ? 1 : 0) != 0);
        Assert.assertTrue((v1.getClass() == v2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)v1.equals(v2));
    }

    public void testInsertAndRetrieve() {
        DefaultKeyedValues data = new DefaultKeyedValues();
        data.addValue((Comparable)((Object)"A"), new Double(1.0));
        data.addValue((Comparable)((Object)"B"), new Double(2.0));
        data.addValue((Comparable)((Object)"C"), new Double(3.0));
        data.addValue((Comparable)((Object)"D"), null);
        Assert.assertEquals((Object)data.getKey(0), (Object)"A");
        Assert.assertEquals((Object)data.getKey(1), (Object)"B");
        Assert.assertEquals((Object)data.getKey(2), (Object)"C");
        Assert.assertEquals((Object)data.getKey(3), (Object)"D");
        Assert.assertEquals((Object)data.getValue((Comparable)((Object)"A")), (Object)new Double(1.0));
        Assert.assertEquals((Object)data.getValue((Comparable)((Object)"B")), (Object)new Double(2.0));
        Assert.assertEquals((Object)data.getValue((Comparable)((Object)"C")), (Object)new Double(3.0));
        Assert.assertEquals((Object)data.getValue((Comparable)((Object)"D")), null);
        Assert.assertEquals((Object)data.getValue(0), (Object)new Double(1.0));
        Assert.assertEquals((Object)data.getValue(1), (Object)new Double(2.0));
        Assert.assertEquals((Object)data.getValue(2), (Object)new Double(3.0));
        Assert.assertEquals((Object)data.getValue(3), null);
    }

    public void testSortByKeyAscending() {
        DefaultKeyedValues data = new DefaultKeyedValues();
        data.addValue((Comparable)((Object)"C"), new Double(1.0));
        data.addValue((Comparable)((Object)"B"), null);
        data.addValue((Comparable)((Object)"D"), new Double(3.0));
        data.addValue((Comparable)((Object)"A"), new Double(2.0));
        data.sortByKeys(SortOrder.ASCENDING);
        Assert.assertEquals((Object)data.getKey(0), (Object)"A");
        Assert.assertEquals((Object)data.getKey(1), (Object)"B");
        Assert.assertEquals((Object)data.getKey(2), (Object)"C");
        Assert.assertEquals((Object)data.getKey(3), (Object)"D");
        Assert.assertEquals((Object)data.getValue((Comparable)((Object)"A")), (Object)new Double(2.0));
        Assert.assertEquals((Object)data.getValue((Comparable)((Object)"B")), null);
        Assert.assertEquals((Object)data.getValue((Comparable)((Object)"C")), (Object)new Double(1.0));
        Assert.assertEquals((Object)data.getValue((Comparable)((Object)"D")), (Object)new Double(3.0));
        Assert.assertEquals((Object)data.getValue(0), (Object)new Double(2.0));
        Assert.assertEquals((Object)data.getValue(1), null);
        Assert.assertEquals((Object)data.getValue(2), (Object)new Double(1.0));
        Assert.assertEquals((Object)data.getValue(3), (Object)new Double(3.0));
    }

    public void testSortByKeyDescending() {
        DefaultKeyedValues data = new DefaultKeyedValues();
        data.addValue((Comparable)((Object)"C"), new Double(1.0));
        data.addValue((Comparable)((Object)"B"), null);
        data.addValue((Comparable)((Object)"D"), new Double(3.0));
        data.addValue((Comparable)((Object)"A"), new Double(2.0));
        data.sortByKeys(SortOrder.DESCENDING);
        Assert.assertEquals((Object)data.getKey(0), (Object)"D");
        Assert.assertEquals((Object)data.getKey(1), (Object)"C");
        Assert.assertEquals((Object)data.getKey(2), (Object)"B");
        Assert.assertEquals((Object)data.getKey(3), (Object)"A");
        Assert.assertEquals((Object)data.getValue((Comparable)((Object)"A")), (Object)new Double(2.0));
        Assert.assertEquals((Object)data.getValue((Comparable)((Object)"B")), null);
        Assert.assertEquals((Object)data.getValue((Comparable)((Object)"C")), (Object)new Double(1.0));
        Assert.assertEquals((Object)data.getValue((Comparable)((Object)"D")), (Object)new Double(3.0));
        Assert.assertEquals((Object)data.getValue(0), (Object)new Double(3.0));
        Assert.assertEquals((Object)data.getValue(1), (Object)new Double(1.0));
        Assert.assertEquals((Object)data.getValue(2), null);
        Assert.assertEquals((Object)data.getValue(3), (Object)new Double(2.0));
    }

    public void testSortByValueAscending() {
        DefaultKeyedValues data = new DefaultKeyedValues();
        data.addValue((Comparable)((Object)"C"), new Double(1.0));
        data.addValue((Comparable)((Object)"B"), null);
        data.addValue((Comparable)((Object)"D"), new Double(3.0));
        data.addValue((Comparable)((Object)"A"), new Double(2.0));
        data.sortByValues(SortOrder.ASCENDING);
        Assert.assertEquals((Object)data.getKey(0), (Object)"C");
        Assert.assertEquals((Object)data.getKey(1), (Object)"A");
        Assert.assertEquals((Object)data.getKey(2), (Object)"D");
        Assert.assertEquals((Object)data.getKey(3), (Object)"B");
        Assert.assertEquals((Object)data.getValue((Comparable)((Object)"A")), (Object)new Double(2.0));
        Assert.assertEquals((Object)data.getValue((Comparable)((Object)"B")), null);
        Assert.assertEquals((Object)data.getValue((Comparable)((Object)"C")), (Object)new Double(1.0));
        Assert.assertEquals((Object)data.getValue((Comparable)((Object)"D")), (Object)new Double(3.0));
        Assert.assertEquals((Object)data.getValue(0), (Object)new Double(1.0));
        Assert.assertEquals((Object)data.getValue(1), (Object)new Double(2.0));
        Assert.assertEquals((Object)data.getValue(2), (Object)new Double(3.0));
        Assert.assertEquals((Object)data.getValue(3), null);
    }

    public void testSortByValueDescending() {
        DefaultKeyedValues data = new DefaultKeyedValues();
        data.addValue((Comparable)((Object)"C"), new Double(1.0));
        data.addValue((Comparable)((Object)"B"), null);
        data.addValue((Comparable)((Object)"D"), new Double(3.0));
        data.addValue((Comparable)((Object)"A"), new Double(2.0));
        data.sortByValues(SortOrder.DESCENDING);
        Assert.assertEquals((Object)data.getKey(0), (Object)"D");
        Assert.assertEquals((Object)data.getKey(1), (Object)"A");
        Assert.assertEquals((Object)data.getKey(2), (Object)"C");
        Assert.assertEquals((Object)data.getKey(3), (Object)"B");
        Assert.assertEquals((Object)data.getValue((Comparable)((Object)"A")), (Object)new Double(2.0));
        Assert.assertEquals((Object)data.getValue((Comparable)((Object)"B")), null);
        Assert.assertEquals((Object)data.getValue((Comparable)((Object)"C")), (Object)new Double(1.0));
        Assert.assertEquals((Object)data.getValue((Comparable)((Object)"D")), (Object)new Double(3.0));
        Assert.assertEquals((Object)data.getValue(0), (Object)new Double(3.0));
        Assert.assertEquals((Object)data.getValue(1), (Object)new Double(2.0));
        Assert.assertEquals((Object)data.getValue(2), (Object)new Double(1.0));
        Assert.assertEquals((Object)data.getValue(3), null);
    }

    public void testSerialization() {
        DefaultKeyedValues v1 = new DefaultKeyedValues();
        v1.addValue((Comparable)((Object)"Key 1"), new Double(23.0));
        v1.addValue((Comparable)((Object)"Key 2"), null);
        v1.addValue((Comparable)((Object)"Key 3"), new Double(42.0));
        DefaultKeyedValues v2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(v1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            v2 = (DefaultKeyedValues)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)v1, v2);
    }
}

