/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.DefaultTableXYDataset;
import org.jfree.data.XYSeries;

public class DefaultTableXYDatasetTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.junit.DefaultTableXYDatasetTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public DefaultTableXYDatasetTests(String name) {
        super(name);
    }

    public void testEquals() {
        DefaultTableXYDataset d1 = new DefaultTableXYDataset();
        XYSeries s1 = new XYSeries("Series 1", true, false);
        s1.add(1.0, 1.1);
        s1.add(2.0, 2.2);
        d1.addSeries(s1);
        DefaultTableXYDataset d2 = new DefaultTableXYDataset();
        XYSeries s2 = new XYSeries("Series 1", true, false);
        s2.add(1.0, 1.1);
        s2.add(2.0, 2.2);
        d2.addSeries(s2);
        Assert.assertTrue((boolean)d1.equals(d2));
        Assert.assertTrue((boolean)d2.equals(d1));
        s1.add(3.0, 3.3);
        Assert.assertFalse((boolean)d1.equals(d2));
        s2.add(3.0, 3.3);
        Assert.assertTrue((boolean)d1.equals(d2));
    }

    public void testCloning() {
        DefaultTableXYDataset d1 = new DefaultTableXYDataset();
        XYSeries s1 = new XYSeries("Series 1", true, false);
        s1.add(1.0, 1.1);
        s1.add(2.0, 2.2);
        d1.addSeries(s1);
        DefaultTableXYDataset d2 = null;
        try {
            d2 = (DefaultTableXYDataset)d1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("DefaultTableXYDataset.testCloning: failed to clone.");
        }
        Assert.assertTrue((d1 != d2 ? 1 : 0) != 0);
        Assert.assertTrue((d1.getClass() == d2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)d1.equals(d2));
    }

    public void testSerialization() {
        DefaultTableXYDataset d1 = new DefaultTableXYDataset();
        XYSeries s1 = new XYSeries("Series 1", true, false);
        s1.add(1.0, 1.1);
        s1.add(2.0, 2.2);
        d1.addSeries(s1);
        DefaultTableXYDataset d2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(d1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            d2 = (DefaultTableXYDataset)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)d1, d2);
    }
}

