/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.KeyToGroupMap;

public class KeyToGroupMapTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.junit.KeyToGroupMapTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public KeyToGroupMapTests(String name) {
        super(name);
    }

    public void testGroupCount() {
        KeyToGroupMap m1 = new KeyToGroupMap((Comparable)((Object)"Default Group"));
        m1.mapKeyToGroup((Comparable)((Object)"C1"), (Comparable)((Object)"G1"));
        Assert.assertEquals((int)2, (int)m1.getGroupCount());
        m1.mapKeyToGroup((Comparable)((Object)"C2"), (Comparable)((Object)"Default Group"));
        Assert.assertEquals((int)2, (int)m1.getGroupCount());
        m1.mapKeyToGroup((Comparable)((Object)"C3"), (Comparable)((Object)"Default Group"));
        m1.mapKeyToGroup((Comparable)((Object)"C4"), (Comparable)((Object)"G2"));
        m1.mapKeyToGroup((Comparable)((Object)"C5"), (Comparable)((Object)"G2"));
        m1.mapKeyToGroup((Comparable)((Object)"C6"), (Comparable)((Object)"Default Group"));
        Assert.assertEquals((int)3, (int)m1.getGroupCount());
        m1.mapKeyToGroup((Comparable)((Object)"C4"), (Comparable)((Object)"G1"));
        m1.mapKeyToGroup((Comparable)((Object)"C5"), (Comparable)((Object)"G1"));
        Assert.assertEquals((int)2, (int)m1.getGroupCount());
    }

    public void testEquals() {
        KeyToGroupMap m1 = new KeyToGroupMap((Comparable)((Object)"Default Group"));
        KeyToGroupMap m2 = new KeyToGroupMap((Comparable)((Object)"Default Group"));
        Assert.assertTrue((boolean)m1.equals(m2));
        Assert.assertTrue((boolean)m2.equals(m1));
    }

    public void testCloning() {
        KeyToGroupMap m1 = new KeyToGroupMap((Comparable)((Object)"Test"));
        KeyToGroupMap m2 = null;
        try {
            m2 = (KeyToGroupMap)m1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("CategoryGroupMapTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((m1 != m2 ? 1 : 0) != 0);
        Assert.assertTrue((m1.getClass() == m2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)m1.equals(m2));
    }

    public void testSerialization() {
        KeyToGroupMap m1 = new KeyToGroupMap((Comparable)((Object)"Test"));
        KeyToGroupMap m2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(m1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            m2 = (KeyToGroupMap)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)m1, m2);
    }
}

