/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.KeyedObjects;

public class KeyedObjectsTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.junit.KeyedObjectsTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public KeyedObjectsTests(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testCloning() {
        KeyedObjects ko1 = new KeyedObjects();
        ko1.addObject((Comparable)((Object)"V1"), new Integer(1));
        ko1.addObject((Comparable)((Object)"V2"), null);
        ko1.addObject((Comparable)((Object)"V3"), new Integer(3));
        KeyedObjects ko2 = null;
        try {
            ko2 = (KeyedObjects)ko1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("KeyedObjectsTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((ko1 != ko2 ? 1 : 0) != 0);
        Assert.assertTrue((ko1.getClass() == ko2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)ko1.equals(ko2));
    }

    public void testInsertAndRetrieve() {
        KeyedObjects data = new KeyedObjects();
        data.addObject((Comparable)((Object)"A"), new Double(1.0));
        data.addObject((Comparable)((Object)"B"), new Double(2.0));
        data.addObject((Comparable)((Object)"C"), new Double(3.0));
        data.addObject((Comparable)((Object)"D"), null);
        Assert.assertEquals((Object)data.getKey(0), (Object)"A");
        Assert.assertEquals((Object)data.getKey(1), (Object)"B");
        Assert.assertEquals((Object)data.getKey(2), (Object)"C");
        Assert.assertEquals((Object)data.getKey(3), (Object)"D");
        Assert.assertEquals((Object)data.getObject((Comparable)((Object)"A")), (Object)new Double(1.0));
        Assert.assertEquals((Object)data.getObject((Comparable)((Object)"B")), (Object)new Double(2.0));
        Assert.assertEquals((Object)data.getObject((Comparable)((Object)"C")), (Object)new Double(3.0));
        Assert.assertEquals((Object)data.getObject((Comparable)((Object)"D")), null);
        Assert.assertEquals((Object)data.getObject((Comparable)((Object)"Not a key")), null);
        Assert.assertEquals((Object)data.getObject(0), (Object)new Double(1.0));
        Assert.assertEquals((Object)data.getObject(1), (Object)new Double(2.0));
        Assert.assertEquals((Object)data.getObject(2), (Object)new Double(3.0));
        Assert.assertEquals((Object)data.getObject(3), null);
    }

    public void testSerialization() {
        KeyedObjects ko1 = new KeyedObjects();
        ko1.addObject((Comparable)((Object)"Key 1"), "Object 1");
        ko1.addObject((Comparable)((Object)"Key 2"), null);
        ko1.addObject((Comparable)((Object)"Key 3"), "Object 2");
        KeyedObjects ko2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(ko1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            ko2 = (KeyedObjects)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)ko1, ko2);
    }
}

