/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.MatrixSeries;

public class MatrixSeriesTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.junit.MatrixSeriesTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public MatrixSeriesTests(String name) {
        super(name);
    }

    public void testEquals() {
        MatrixSeries m1 = new MatrixSeries("Test", 8, 3);
        m1.update(0, 0, 11.0);
        m1.update(7, 2, 22.0);
        MatrixSeries m2 = new MatrixSeries("Test", 8, 3);
        m2.update(0, 0, 11.0);
        m2.update(7, 2, 22.0);
        Assert.assertTrue((boolean)m1.equals(m2));
        Assert.assertTrue((boolean)m2.equals(m1));
        m1 = new MatrixSeries("Test 2", 8, 3);
        Assert.assertFalse((boolean)m1.equals(m2));
        m2 = new MatrixSeries("Test 2", 8, 3);
        Assert.assertTrue((boolean)m1.equals(m2));
        m1 = new MatrixSeries("Test 2", 10, 3);
        Assert.assertFalse((boolean)m1.equals(m2));
        m2 = new MatrixSeries("Test 2", 10, 3);
        Assert.assertTrue((boolean)m1.equals(m2));
        m1 = new MatrixSeries("Test 2", 10, 5);
        Assert.assertFalse((boolean)m1.equals(m2));
        m2 = new MatrixSeries("Test 2", 10, 5);
        Assert.assertTrue((boolean)m1.equals(m2));
    }

    public void testCloning() {
        MatrixSeries m1 = new MatrixSeries("Test", 8, 3);
        m1.update(0, 0, 11.0);
        m1.update(7, 2, 22.0);
        MatrixSeries m2 = null;
        try {
            m2 = (MatrixSeries)m1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        Assert.assertTrue((m1 != m2 ? 1 : 0) != 0);
        Assert.assertTrue((m1.getClass() == m2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)m1.equals(m2));
    }

    public void testSerialization() {
        MatrixSeries m1 = new MatrixSeries("Test", 8, 3);
        m1.update(0, 0, 11.0);
        m1.update(7, 2, 22.0);
        MatrixSeries m2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(m1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            m2 = (MatrixSeries)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)m1, m2);
    }

    public void testGetItemColumn() {
        MatrixSeries m = new MatrixSeries("Test", 3, 2);
        Assert.assertEquals((int)0, (int)m.getItemColumn(0));
        Assert.assertEquals((int)1, (int)m.getItemColumn(1));
        Assert.assertEquals((int)0, (int)m.getItemColumn(2));
        Assert.assertEquals((int)1, (int)m.getItemColumn(3));
        Assert.assertEquals((int)0, (int)m.getItemColumn(4));
        Assert.assertEquals((int)1, (int)m.getItemColumn(5));
    }

    public void testGetItemRow() {
        MatrixSeries m = new MatrixSeries("Test", 3, 2);
        Assert.assertEquals((int)0, (int)m.getItemRow(0));
        Assert.assertEquals((int)0, (int)m.getItemRow(1));
        Assert.assertEquals((int)1, (int)m.getItemRow(2));
        Assert.assertEquals((int)1, (int)m.getItemRow(3));
        Assert.assertEquals((int)2, (int)m.getItemRow(4));
        Assert.assertEquals((int)2, (int)m.getItemRow(5));
    }

    public void testGetItem() {
        MatrixSeries m = new MatrixSeries("Test", 3, 2);
        m.update(0, 0, 0.0);
        m.update(0, 1, 1.0);
        m.update(1, 0, 2.0);
        m.update(1, 1, 3.0);
        m.update(2, 0, 4.0);
        m.update(2, 1, 5.0);
        Assert.assertEquals((double)0.0, (double)m.getItem(0).doubleValue(), (double)0.001);
        Assert.assertEquals((double)1.0, (double)m.getItem(1).doubleValue(), (double)0.001);
        Assert.assertEquals((double)2.0, (double)m.getItem(2).doubleValue(), (double)0.001);
        Assert.assertEquals((double)3.0, (double)m.getItem(3).doubleValue(), (double)0.001);
        Assert.assertEquals((double)4.0, (double)m.getItem(4).doubleValue(), (double)0.001);
        Assert.assertEquals((double)5.0, (double)m.getItem(5).doubleValue(), (double)0.001);
    }
}

