/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.MovingAverage;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.util.NumberUtils;

public class MovingAverageTests
extends TestCase {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.junit.MovingAverageTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public MovingAverageTests(String name) {
        super(name);
    }

    public void test1() {
        TimeSeries source = this.createDailyTimeSeries1();
        TimeSeries maverage = MovingAverage.createMovingAverage(source, "Moving Average", 3, 3);
        Assert.assertEquals((int)7, (int)maverage.getItemCount());
        double value = maverage.getValue(0).doubleValue();
        Assert.assertTrue((boolean)NumberUtils.equal(value, 14.1));
        value = maverage.getValue(1).doubleValue();
        Assert.assertTrue((boolean)NumberUtils.equal(value, 13.4));
        value = maverage.getValue(2).doubleValue();
        Assert.assertTrue((boolean)NumberUtils.equal(value, 14.43333333333));
        value = maverage.getValue(3).doubleValue();
        Assert.assertTrue((boolean)NumberUtils.equal(value, 14.93333333333));
        value = maverage.getValue(4).doubleValue();
        Assert.assertTrue((boolean)NumberUtils.equal(value, 19.8));
        value = maverage.getValue(5).doubleValue();
        Assert.assertTrue((boolean)NumberUtils.equal(value, 15.25));
        value = maverage.getValue(6).doubleValue();
        Assert.assertTrue((boolean)NumberUtils.equal(value, 12.5));
    }

    private TimeSeries createDailyTimeSeries1() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.jfree.data.time.Day");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TimeSeries series = new TimeSeries("Series 1", clazz);
        series.add((RegularTimePeriod)new Day(11, 8, 2003), 11.2);
        series.add((RegularTimePeriod)new Day(13, 8, 2003), 13.8);
        series.add((RegularTimePeriod)new Day(17, 8, 2003), 14.1);
        series.add((RegularTimePeriod)new Day(18, 8, 2003), 12.7);
        series.add((RegularTimePeriod)new Day(19, 8, 2003), 16.5);
        series.add((RegularTimePeriod)new Day(20, 8, 2003), 15.6);
        series.add((RegularTimePeriod)new Day(25, 8, 2003), 19.8);
        series.add((RegularTimePeriod)new Day(27, 8, 2003), 10.7);
        series.add((RegularTimePeriod)new Day(28, 8, 2003), 14.3);
        return series;
    }
}

