/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.Range;

public class RangeTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.junit.RangeTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public RangeTests(String name) {
        super(name);
    }

    public void testEquals() {
        Range r1 = new Range(0.0, 1.0);
        Range r2 = new Range(0.0, 1.0);
        Assert.assertEquals((Object)r1, (Object)r2);
        Assert.assertEquals((Object)r2, (Object)r1);
        r1 = new Range(0.0, 1.0);
        r2 = new Range(0.5, 1.0);
        Assert.assertFalse((boolean)r1.equals(r2));
        r1 = new Range(0.0, 1.0);
        r2 = new Range(0.0, 2.0);
        Assert.assertFalse((boolean)r1.equals(r2));
    }

    public void testContains() {
        Range r1 = new Range(0.0, 1.0);
        Assert.assertFalse((boolean)r1.contains(Double.NaN));
        Assert.assertFalse((boolean)r1.contains(Double.NEGATIVE_INFINITY));
        Assert.assertFalse((boolean)r1.contains(-1.0));
        Assert.assertTrue((boolean)r1.contains(0.0));
        Assert.assertTrue((boolean)r1.contains(0.5));
        Assert.assertTrue((boolean)r1.contains(1.0));
        Assert.assertFalse((boolean)r1.contains(2.0));
        Assert.assertFalse((boolean)r1.contains(Double.POSITIVE_INFINITY));
    }

    public void testConstrain() {
        Range r1 = new Range(0.0, 1.0);
        double d = r1.constrain(0.5);
        Assert.assertEquals((double)0.5, (double)d, (double)1.0E-7);
        d = r1.constrain(0.0);
        Assert.assertEquals((double)0.0, (double)d, (double)1.0E-7);
        d = r1.constrain(1.0);
        Assert.assertEquals((double)1.0, (double)d, (double)1.0E-7);
        d = r1.constrain(-1.0);
        Assert.assertEquals((double)0.0, (double)d, (double)1.0E-7);
        d = r1.constrain(2.0);
        Assert.assertEquals((double)1.0, (double)d, (double)1.0E-7);
        d = r1.constrain(Double.POSITIVE_INFINITY);
        Assert.assertEquals((double)1.0, (double)d, (double)1.0E-7);
        d = r1.constrain(Double.NEGATIVE_INFINITY);
        Assert.assertEquals((double)0.0, (double)d, (double)1.0E-7);
        d = r1.constrain(Double.NaN);
        Assert.assertTrue((boolean)Double.isNaN(d));
    }

    public void testIntersects() {
        Range r1 = new Range(0.0, 1.0);
        Assert.assertFalse((boolean)r1.intersects(-2.0, -1.0));
        Assert.assertFalse((boolean)r1.intersects(-2.0, 0.0));
        Assert.assertTrue((boolean)r1.intersects(-2.0, 0.5));
        Assert.assertTrue((boolean)r1.intersects(-2.0, 1.0));
        Assert.assertTrue((boolean)r1.intersects(-2.0, 1.5));
        Assert.assertTrue((boolean)r1.intersects(0.0, 0.5));
        Assert.assertTrue((boolean)r1.intersects(0.0, 1.0));
        Assert.assertTrue((boolean)r1.intersects(0.0, 1.5));
        Assert.assertTrue((boolean)r1.intersects(0.5, 0.6));
        Assert.assertTrue((boolean)r1.intersects(0.5, 1.0));
        Assert.assertTrue((boolean)r1.intersects(0.5, 1.5));
        Assert.assertFalse((boolean)r1.intersects(1.0, 1.1));
        Assert.assertFalse((boolean)r1.intersects(1.5, 2.0));
    }

    public void testExpand() {
        Range r1 = new Range(0.0, 100.0);
        Range r2 = Range.expand(r1, 0.1, 0.1);
        Assert.assertEquals((double)-10.0, (double)r2.getLowerBound(), (double)0.001);
        Assert.assertEquals((double)110.0, (double)r2.getUpperBound(), (double)0.001);
    }

    public void testSerialization() {
        Range r1 = new Range(25.0, 133.42);
        Range r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (Range)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)r1, r2);
    }
}

