/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.DefaultTableXYDataset;
import org.jfree.data.XYSeries;

public class TableXYDatasetTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.junit.TableXYDatasetTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public TableXYDatasetTests(String name) {
        super(name);
    }

    public void testEquals() {
        DefaultTableXYDataset d1 = new DefaultTableXYDataset();
        DefaultTableXYDataset d2 = new DefaultTableXYDataset();
        Assert.assertTrue((boolean)d1.equals(d2));
        Assert.assertTrue((boolean)d2.equals(d1));
        d1.addSeries(this.createSeries1());
        Assert.assertFalse((boolean)d1.equals(d2));
        d2.addSeries(this.createSeries1());
        Assert.assertTrue((boolean)d1.equals(d2));
    }

    public void testCloning() {
        DefaultTableXYDataset d1 = new DefaultTableXYDataset();
        d1.addSeries(this.createSeries1());
        DefaultTableXYDataset d2 = null;
        try {
            d2 = (DefaultTableXYDataset)d1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("DefaultTableXYDataset.testCloning: failed to clone.");
        }
        Assert.assertTrue((d1 != d2 ? 1 : 0) != 0);
        Assert.assertTrue((d1.getClass() == d2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)d1.equals(d2));
    }

    public void testSerialization() {
        DefaultTableXYDataset d1 = new DefaultTableXYDataset();
        d1.addSeries(this.createSeries2());
        DefaultTableXYDataset d2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(d1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            d2 = (DefaultTableXYDataset)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)d1, d2);
    }

    public void testTableXYDataset() {
        XYSeries series1 = this.createSeries1();
        XYSeries series2 = this.createSeries2();
        DefaultTableXYDataset dataset = new DefaultTableXYDataset();
        dataset.addSeries(series1);
        dataset.addSeries(series2);
        Assert.assertEquals((int)6, (int)dataset.getItemCount());
        Assert.assertEquals((int)6, (int)dataset.getXValue(0, 5).intValue());
        Assert.assertEquals(null, (Object)dataset.getYValue(0, 5));
        Assert.assertEquals((int)6, (int)dataset.getXValue(1, 5).intValue());
        Assert.assertEquals((int)2, (int)dataset.getYValue(1, 5).intValue());
        series2.add(7.0, 2.0);
        Assert.assertEquals((int)7, (int)dataset.getItemCount());
        Assert.assertEquals(null, (Object)dataset.getYValue(0, 6));
        Assert.assertEquals((int)2, (int)dataset.getYValue(1, 6).intValue());
        dataset.removeSeries(series1);
        Assert.assertEquals((int)7, (int)dataset.getItemCount());
        dataset.removeSeries(series2);
        series1 = this.createSeries1();
        dataset.addSeries(series1);
        Assert.assertEquals((int)4, (int)dataset.getItemCount());
    }

    public void test788597() {
        DefaultTableXYDataset dataset = new DefaultTableXYDataset();
        dataset.addSeries(this.createSeries1());
        Assert.assertEquals((int)4, (int)dataset.getItemCount());
        dataset.removeAllSeries();
        Assert.assertEquals((int)0, (int)dataset.getItemCount());
    }

    public void testRemoveAllValuesForX() {
        DefaultTableXYDataset dataset = new DefaultTableXYDataset();
        dataset.addSeries(this.createSeries1());
        dataset.addSeries(this.createSeries2());
        dataset.removeAllValuesForX(new Double(2.0));
        Assert.assertEquals((int)5, (int)dataset.getItemCount());
        Assert.assertEquals((Object)new Double(1.0), (Object)dataset.getXValue(0, 0));
        Assert.assertEquals((Object)new Double(3.0), (Object)dataset.getXValue(0, 1));
        Assert.assertEquals((Object)new Double(4.0), (Object)dataset.getXValue(0, 2));
        Assert.assertEquals((Object)new Double(5.0), (Object)dataset.getXValue(0, 3));
        Assert.assertEquals((Object)new Double(6.0), (Object)dataset.getXValue(0, 4));
    }

    public void testPrune() {
        DefaultTableXYDataset dataset = new DefaultTableXYDataset();
        dataset.addSeries(this.createSeries1());
        dataset.addSeries(this.createSeries2());
        dataset.removeSeries(1);
        dataset.prune();
        Assert.assertEquals((int)4, (int)dataset.getItemCount());
    }

    public void testAutoPrune() {
        DefaultTableXYDataset dataset = new DefaultTableXYDataset(true);
        dataset.addSeries(this.createSeriesA());
        Assert.assertEquals((int)2, (int)dataset.getItemCount());
        dataset.addSeries(this.createSeriesB());
        Assert.assertEquals((int)2, (int)dataset.getItemCount());
        dataset.removeSeries(1);
        Assert.assertEquals((int)1, (int)dataset.getItemCount());
        DefaultTableXYDataset dataset2 = new DefaultTableXYDataset(true);
        dataset2.addSeries(this.createSeriesA());
        Assert.assertEquals((int)2, (int)dataset2.getItemCount());
        dataset2.addSeries(this.createSeriesB());
        Assert.assertEquals((int)2, (int)dataset2.getItemCount());
        dataset2.removeSeries(1);
        Assert.assertEquals((int)1, (int)dataset2.getItemCount());
    }

    private XYSeries createSeriesA() {
        XYSeries s = new XYSeries("A", true, false);
        s.add(1.0, 1.1);
        s.add(2.0, (Number)null);
        return s;
    }

    private XYSeries createSeriesB() {
        XYSeries s = new XYSeries("B", true, false);
        s.add(1.0, (Number)null);
        s.add(2.0, 2.2);
        return s;
    }

    private XYSeries createSeries1() {
        XYSeries series1 = new XYSeries("Series 1", true, false);
        series1.add(1.0, 1.0);
        series1.add(2.0, 1.0);
        series1.add(4.0, 1.0);
        series1.add(5.0, 1.0);
        return series1;
    }

    private XYSeries createSeries2() {
        XYSeries series2 = new XYSeries("Series 2", true, false);
        series2.add(2.0, 2.0);
        series2.add(3.0, 2.0);
        series2.add(4.0, 2.0);
        series2.add(5.0, 2.0);
        series2.add(6.0, 2.0);
        return series2;
    }
}

