/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.XYSeries;

public class XYSeriesTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.junit.XYSeriesTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public XYSeriesTests(String name) {
        super(name);
    }

    public void testEquals() {
        XYSeries s1 = new XYSeries("Series");
        s1.add(1.0, 1.1);
        XYSeries s2 = new XYSeries("Series");
        s2.add(1.0, 1.1);
        Assert.assertTrue((boolean)s1.equals(s2));
        Assert.assertTrue((boolean)s2.equals(s1));
        s1.setName("Series X");
        Assert.assertFalse((boolean)s1.equals(s2));
        s2.setName("Series X");
        Assert.assertTrue((boolean)s1.equals(s2));
    }

    public void testCloning() {
        XYSeries s1 = new XYSeries("Series");
        s1.add(1.0, 1.1);
        XYSeries s2 = null;
        try {
            s2 = (XYSeries)s1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("XYSeriesTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((s1 != s2 ? 1 : 0) != 0);
        Assert.assertTrue((s1.getClass() == s2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s1.equals(s2));
    }

    public void testSerialization() {
        XYSeries s1 = new XYSeries("Series");
        s1.add(1.0, 1.1);
        XYSeries s2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(s1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            s2 = (XYSeries)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)s1, s2);
    }

    public void testIndexOf() {
        XYSeries s1 = new XYSeries("Series 1");
        s1.add(1.0, 1.0);
        s1.add(2.0, 2.0);
        s1.add(3.0, 3.0);
        Assert.assertEquals((int)0, (int)s1.indexOf(new Double(1.0)));
    }

    public void testRemove() {
        XYSeries s1 = new XYSeries("Series 1");
        s1.add(1.0, 1.0);
        s1.add(2.0, 2.0);
        s1.add(3.0, 3.0);
        Assert.assertEquals((int)3, (int)s1.getItemCount());
        s1.remove(new Double(2.0));
        Assert.assertEquals((Object)new Double(3.0), (Object)s1.getXValue(1));
        s1.remove(0);
        Assert.assertEquals((Object)new Double(3.0), (Object)s1.getXValue(0));
    }
}

