/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.data.AbstractIntervalXYDataset;
import org.jfree.data.DatasetChangeEvent;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.statistics.HistogramBin;
import org.jfree.data.statistics.HistogramType;
import org.jfree.util.ObjectUtils;

public class HistogramDataset
extends AbstractIntervalXYDataset
implements IntervalXYDataset,
Cloneable,
Serializable {
    private List list = new ArrayList();
    private HistogramType type = HistogramType.FREQUENCY;

    public HistogramType getType() {
        return this.type;
    }

    public void setType(HistogramType type) {
        if (type == null) {
            throw new IllegalArgumentException("Null 'type' argument");
        }
        this.type = type;
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public void addSeries(String name, double[] values, int bins) {
        double minimum = this.getMinimum(values);
        double maximum = this.getMaximum(values);
        this.addSeries(name, values, bins, minimum, maximum);
    }

    public void addSeries(String name, double[] values, int bins, double minimum, double maximum) {
        if (name == null) {
            throw new IllegalArgumentException("Null 'name' argument.");
        }
        if (values == null) {
            throw new IllegalArgumentException("Null 'values' argument.");
        }
        if (bins < 1) {
            throw new IllegalArgumentException("The 'bins' value must be at least 1.");
        }
        double binWidth = (maximum - minimum) / (double)bins;
        double tmp = minimum;
        ArrayList<HistogramBin> binList = new ArrayList<HistogramBin>(bins);
        int i = 0;
        while (i < bins) {
            HistogramBin bin = i == bins - 1 ? new HistogramBin(tmp, maximum) : new HistogramBin(tmp, tmp + binWidth);
            tmp += binWidth;
            binList.add(bin);
            ++i;
        }
        i = 0;
        while (i < values.length) {
            int j = 0;
            while (j < bins) {
                HistogramBin currentBin = (HistogramBin)binList.get(j);
                if (values[i] >= currentBin.getStartBoundary() && values[i] <= currentBin.getEndBoundary()) {
                    currentBin.incrementCount();
                    break;
                }
                ++j;
            }
            ++i;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", name);
        map.put("bins", binList);
        map.put("values.length", new Integer(values.length));
        map.put("bin width", new Double(binWidth));
        this.list.add(map);
    }

    private double getMinimum(double[] values) {
        if (values == null || values.length < 1) {
            throw new IllegalArgumentException("Null or zero length 'values' argument.");
        }
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < values.length) {
            if (values[i] < min) {
                min = values[i];
            }
            ++i;
        }
        return min;
    }

    private double getMaximum(double[] values) {
        if (values == null || values.length < 1) {
            throw new IllegalArgumentException("Null or zero length 'values' argument.");
        }
        double max = -1.7976931348623157E308;
        int i = 0;
        while (i < values.length) {
            if (values[i] > max) {
                max = values[i];
            }
            ++i;
        }
        return max;
    }

    List getBins(int series) {
        Map map = (Map)this.list.get(series);
        return (List)map.get("bins");
    }

    private int getTotal(int series) {
        Map map = (Map)this.list.get(series);
        return (Integer)map.get("values.length");
    }

    private double getBinWidth(int series) {
        Map map = (Map)this.list.get(series);
        return (Double)map.get("bin width");
    }

    public int getSeriesCount() {
        return this.list.size();
    }

    public String getSeriesName(int series) {
        Map map = (Map)this.list.get(series);
        return (String)map.get("name");
    }

    public int getItemCount(int series) {
        return this.getBins(series).size();
    }

    public Number getXValue(int series, int item) {
        List bins = this.getBins(series);
        HistogramBin bin = (HistogramBin)bins.get(item);
        double x = (bin.getStartBoundary() + bin.getEndBoundary()) / 2.0;
        return new Double(x);
    }

    public Number getYValue(int series, int item) {
        List bins = this.getBins(series);
        HistogramBin bin = (HistogramBin)bins.get(item);
        double total = this.getTotal(series);
        double binWidth = this.getBinWidth(series);
        if (this.type == HistogramType.FREQUENCY) {
            return new Double(bin.getCount());
        }
        if (this.type == HistogramType.RELATIVE_FREQUENCY) {
            return new Double((double)bin.getCount() / total);
        }
        if (this.type == HistogramType.SCALE_AREA_TO_1) {
            return new Double((double)bin.getCount() / (binWidth * total));
        }
        throw new IllegalStateException();
    }

    public Number getStartXValue(int series, int item) {
        List bins = this.getBins(series);
        HistogramBin bin = (HistogramBin)bins.get(item);
        return new Double(bin.getStartBoundary());
    }

    public Number getEndXValue(int series, int item) {
        List bins = this.getBins(series);
        HistogramBin bin = (HistogramBin)bins.get(item);
        return new Double(bin.getEndBoundary());
    }

    public Number getStartYValue(int series, int item) {
        return this.getYValue(series, item);
    }

    public Number getEndYValue(int series, int item) {
        return this.getYValue(series, item);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof HistogramDataset) {
            HistogramDataset dataset = (HistogramDataset)obj;
            boolean b0 = ObjectUtils.equal(dataset.type, this.type);
            boolean b1 = ObjectUtils.equal(dataset.list, this.list);
            return b0 && b1;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

