/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.statistics.HistogramBin;

public class HistogramBinTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.statistics.junit.HistogramBinTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public HistogramBinTests(String name) {
        super(name);
    }

    public void testEquals() {
        double start = 10.0;
        double end = 20.0;
        HistogramBin b1 = new HistogramBin(10.0, 20.0);
        HistogramBin b2 = new HistogramBin(10.0, 20.0);
        Assert.assertTrue((boolean)b1.equals(b2));
        Assert.assertTrue((boolean)b2.equals(b1));
    }

    public void testCloning() {
        double start = 10.0;
        double end = 20.0;
        HistogramBin b1 = new HistogramBin(10.0, 20.0);
        HistogramBin b2 = null;
        try {
            b2 = (HistogramBin)b1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        Assert.assertTrue((b1 != b2 ? 1 : 0) != 0);
        Assert.assertTrue((b1.getClass() == b2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)b1.equals(b2));
    }

    public void testSerialization() {
        double start = 10.0;
        double end = 20.0;
        HistogramBin b1 = new HistogramBin(10.0, 20.0);
        HistogramBin b2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(b1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            b2 = (HistogramBin)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)b1, b2);
    }
}

