/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.util.Calendar;
import java.util.TimeZone;
import org.jfree.data.AbstractIntervalXYDataset;
import org.jfree.data.DomainInfo;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.SeriesChangeEvent;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;

public class DynamicTimeSeriesCollection
extends AbstractIntervalXYDataset
implements IntervalXYDataset,
DomainInfo,
RangeInfo {
    public static final int START = 0;
    public static final int MIDDLE = 1;
    public static final int END = 2;
    private int maximumItemCount = 2000;
    protected int historyCount;
    private String[] seriesNames;
    private Class timePeriodClass;
    protected RegularTimePeriod[] pointsInTime;
    private int seriesCount;
    protected ValueSequence[] valueHistory;
    protected Calendar workingCalendar;
    private int position;
    private boolean domainIsPointsInTime;
    private int oldestAt;
    private int newestAt;
    private long deltaTime;
    private Long domainStart;
    private Long domainEnd;
    private Range domainRange;
    private Float minValue;
    private Float maxValue;
    private Range valueRange;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public DynamicTimeSeriesCollection(int nSeries, int nMoments) {
        this(nSeries, nMoments, new Millisecond(), TimeZone.getDefault());
        this.newestAt = nMoments - 1;
    }

    public DynamicTimeSeriesCollection(int nSeries, int nMoments, TimeZone zone) {
        this(nSeries, nMoments, new Millisecond(), zone);
        this.newestAt = nMoments - 1;
    }

    public DynamicTimeSeriesCollection(int nSeries, int nMoments, RegularTimePeriod timeSample) {
        this(nSeries, nMoments, timeSample, TimeZone.getDefault());
    }

    public DynamicTimeSeriesCollection(int nSeries, int nMoments, RegularTimePeriod timeSample, TimeZone zone) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.Minute");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.timePeriodClass = clazz;
        this.minValue = new Float(0.0f);
        this.maxValue = null;
        this.maximumItemCount = nMoments;
        this.historyCount = nMoments;
        this.seriesNames = new String[nSeries];
        int i = 0;
        while (i < nSeries) {
            this.seriesNames[i] = "";
            ++i;
        }
        this.newestAt = nMoments - 1;
        this.valueHistory = new ValueSequence[nSeries];
        this.timePeriodClass = timeSample.getClass();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.jfree.data.time.Second");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (this.timePeriodClass == clazz2) {
            this.pointsInTime = new Second[nMoments];
        } else {
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("org.jfree.data.time.Minute");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (this.timePeriodClass == clazz3) {
                this.pointsInTime = new Minute[nMoments];
            } else {
                Class<?> clazz4 = class$2;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$2 = Class.forName("org.jfree.data.time.Hour");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (this.timePeriodClass == clazz4) {
                    this.pointsInTime = new Hour[nMoments];
                }
            }
        }
        this.workingCalendar = Calendar.getInstance(zone);
        this.position = 0;
        this.domainIsPointsInTime = true;
    }

    public synchronized long setTimeBase(RegularTimePeriod start) {
        if (this.pointsInTime[0] == null) {
            this.pointsInTime[0] = start;
            int i = 1;
            while (i < this.historyCount) {
                this.pointsInTime[i] = this.pointsInTime[i - 1].next();
                ++i;
            }
        }
        long oldestL = this.pointsInTime[0].getFirstMillisecond(this.workingCalendar);
        long nextL = this.pointsInTime[1].getFirstMillisecond(this.workingCalendar);
        this.deltaTime = nextL - oldestL;
        this.oldestAt = 0;
        this.newestAt = this.historyCount - 1;
        this.findDomainLimits();
        return this.deltaTime;
    }

    protected void findDomainLimits() {
        long startL = this.getOldestTime().getFirstMillisecond(this.workingCalendar);
        long endL = this.domainIsPointsInTime ? this.getNewestTime().getFirstMillisecond(this.workingCalendar) : this.getNewestTime().getLastMillisecond(this.workingCalendar);
        this.domainStart = new Long(startL);
        this.domainEnd = new Long(endL);
        this.domainRange = new Range(startL, endL);
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void addSeries(float[] values, int seriesNumber, String seriesName) {
        this.invalidateRangeInfo();
        if (values == null) {
            throw new IllegalArgumentException("TimeSeriesDataset.addSeries(...): cannot add null array of values.");
        }
        if (seriesNumber >= this.valueHistory.length) {
            throw new IllegalArgumentException("TimeSeriesDataset.addSeries(...): cannot add more series than specified in c'tor");
        }
        if (this.valueHistory[seriesNumber] == null) {
            this.valueHistory[seriesNumber] = new ValueSequence(this.historyCount);
            ++this.seriesCount;
        }
        int srcLength = values.length;
        int copyLength = this.historyCount;
        boolean fillNeeded = false;
        if (srcLength < this.historyCount) {
            fillNeeded = true;
            copyLength = srcLength;
        }
        int i = 0;
        while (i < copyLength) {
            this.valueHistory[seriesNumber].enterData(i, values[i]);
            ++i;
        }
        if (fillNeeded) {
            i = copyLength;
            while (i < this.historyCount) {
                this.valueHistory[seriesNumber].enterData(i, 0.0f);
                ++i;
            }
        }
        if (seriesName != null) {
            this.seriesNames[seriesNumber] = seriesName;
        }
        this.fireSeriesChanged();
    }

    public void setSeriesName(int seriesNumber, String newName) {
        this.seriesNames[seriesNumber] = newName;
    }

    public void addValue(int seriesNumber, int index, float value) {
        this.invalidateRangeInfo();
        if (seriesNumber >= this.valueHistory.length) {
            throw new IllegalArgumentException("TimeSeriesDataset.addValue(...): series #" + seriesNumber + "unspecified in c'tor");
        }
        if (this.valueHistory[seriesNumber] == null) {
            this.valueHistory[seriesNumber] = new ValueSequence(this.historyCount);
            ++this.seriesCount;
        }
        this.valueHistory[seriesNumber].enterData(index, value);
        this.fireSeriesChanged();
    }

    public int getSeriesCount() {
        return this.seriesCount;
    }

    public int getItemCount(int series) {
        return this.historyCount;
    }

    protected int translateGet(int toFetch) {
        if (this.oldestAt == 0) {
            return toFetch;
        }
        int newIndex = toFetch + this.oldestAt;
        if (newIndex >= this.historyCount) {
            newIndex -= this.historyCount;
        }
        return newIndex;
    }

    public int offsetFromNewest(int delta) {
        return this.wrapOffset(this.newestAt + delta);
    }

    public int offsetFromOldest(int delta) {
        return this.wrapOffset(this.oldestAt + delta);
    }

    protected int wrapOffset(int protoIndex) {
        int tmp = protoIndex;
        if (tmp >= this.historyCount) {
            tmp -= this.historyCount;
        } else if (tmp < 0) {
            tmp += this.historyCount;
        }
        return tmp;
    }

    public synchronized RegularTimePeriod advanceTime() {
        RegularTimePeriod nextInstant = this.pointsInTime[this.newestAt].next();
        this.newestAt = this.oldestAt;
        boolean extremaChanged = false;
        float oldMax = 0.0f;
        if (this.maxValue != null) {
            oldMax = this.maxValue.floatValue();
        }
        int s = 0;
        while (s < this.getSeriesCount()) {
            if (this.valueHistory[s].getData(this.oldestAt) == oldMax) {
                extremaChanged = true;
            }
            if (extremaChanged) break;
            ++s;
        }
        if (extremaChanged) {
            this.invalidateRangeInfo();
        }
        float wiper = 0.0f;
        int s2 = 0;
        while (s2 < this.getSeriesCount()) {
            this.valueHistory[s2].enterData(this.newestAt, 0.0f);
            ++s2;
        }
        this.pointsInTime[this.newestAt] = nextInstant;
        ++this.oldestAt;
        if (this.oldestAt >= this.historyCount) {
            this.oldestAt = 0;
        }
        long startL = this.domainStart;
        this.domainStart = new Long(startL + this.deltaTime);
        long endL = this.domainEnd;
        this.domainEnd = new Long(endL + this.deltaTime);
        this.domainRange = new Range(startL, endL);
        this.fireSeriesChanged();
        return nextInstant;
    }

    public void invalidateRangeInfo() {
        this.maxValue = null;
        this.valueRange = null;
    }

    protected double findMaxValue() {
        double max = 0.0;
        int s = 0;
        while (s < this.getSeriesCount()) {
            int i = 0;
            while (i < this.historyCount) {
                double tmp = this.getY(s, i);
                if (tmp > max) {
                    max = tmp;
                }
                ++i;
            }
            ++s;
        }
        return max;
    }

    public int getOldestIndex() {
        return this.oldestAt;
    }

    public int getNewestIndex() {
        return this.newestAt;
    }

    public void appendData(float[] newData) {
        int nDataPoints = newData.length;
        if (nDataPoints > this.valueHistory.length) {
            throw new IllegalArgumentException("DynamicTimeSeriesCollection.appendData(...): more data than series to put them in");
        }
        int s = 0;
        while (s < nDataPoints) {
            if (this.valueHistory[s] == null) {
                this.valueHistory[s] = new ValueSequence(this.historyCount);
            }
            this.valueHistory[s].enterData(this.newestAt, newData[s]);
            ++s;
        }
        this.fireSeriesChanged();
    }

    public void appendData(float[] newData, int insertionIndex, int refresh) {
        int nDataPoints = newData.length;
        if (nDataPoints > this.valueHistory.length) {
            throw new IllegalArgumentException("DynamicTimeSeriesCollection.appendData(...): more data than series to put them in");
        }
        int s = 0;
        while (s < nDataPoints) {
            if (this.valueHistory[s] == null) {
                this.valueHistory[s] = new ValueSequence(this.historyCount);
            }
            this.valueHistory[s].enterData(insertionIndex, newData[s]);
            ++s;
        }
        if (refresh > 0 && ++insertionIndex % refresh == 0) {
            this.fireSeriesChanged();
        }
    }

    public RegularTimePeriod getNewestTime() {
        return this.pointsInTime[this.newestAt];
    }

    public RegularTimePeriod getOldestTime() {
        return this.pointsInTime[this.oldestAt];
    }

    public Number getXValue(int series, int item) {
        RegularTimePeriod tp = this.pointsInTime[this.translateGet(item)];
        return new Long(this.getX(tp));
    }

    public double getY(int series, int item) {
        ValueSequence values = this.valueHistory[series];
        return values.getData(this.translateGet(item));
    }

    public Number getYValue(int series, int item) {
        return new Float(this.getY(series, item));
    }

    public Number getStartXValue(int series, int item) {
        RegularTimePeriod tp = this.pointsInTime[this.translateGet(item)];
        return new Long(tp.getFirstMillisecond(this.workingCalendar));
    }

    public Number getEndXValue(int series, int item) {
        RegularTimePeriod tp = this.pointsInTime[this.translateGet(item)];
        return new Long(tp.getLastMillisecond(this.workingCalendar));
    }

    public Number getStartYValue(int series, int item) {
        return this.getYValue(series, item);
    }

    public Number getEndYValue(int series, int item) {
        return this.getYValue(series, item);
    }

    public String getSeriesName(int series) {
        return this.seriesNames[series];
    }

    protected void fireSeriesChanged() {
        this.seriesChanged(new SeriesChangeEvent(this));
    }

    public Range getDomainRange() {
        if (this.domainRange == null) {
            this.findDomainLimits();
        }
        return this.domainRange;
    }

    public Number getMinimumDomainValue() {
        return this.domainStart;
    }

    public Number getMaximumDomainValue() {
        return this.domainEnd;
    }

    private long getX(RegularTimePeriod period) {
        switch (this.position) {
            case 0: {
                return period.getFirstMillisecond(this.workingCalendar);
            }
            case 1: {
                return period.getMiddleMillisecond(this.workingCalendar);
            }
            case 2: {
                return period.getLastMillisecond(this.workingCalendar);
            }
        }
        return period.getMiddleMillisecond(this.workingCalendar);
    }

    public Number getMinimumRangeValue() {
        return this.minValue;
    }

    public Number getMaximumRangeValue() {
        if (this.maxValue == null) {
            this.maxValue = new Float(this.findMaxValue());
        }
        return this.maxValue;
    }

    public Range getValueRange() {
        if (this.valueRange == null) {
            Float maxV = (Float)this.getMaximumRangeValue();
            double max = maxV.doubleValue();
            this.valueRange = new Range(0.0, max);
        }
        return this.valueRange;
    }

    protected class ValueSequence {
        float[] dataPoints;

        public ValueSequence() {
            this(dynamicTimeSeriesCollection.maximumItemCount);
        }

        public ValueSequence(int length) {
            this.dataPoints = new float[length];
            int i = 0;
            while (i < length) {
                this.dataPoints[i] = 0.0f;
                ++i;
            }
        }

        public void enterData(int index, float value) {
            this.dataPoints[index] = value;
        }

        public float getData(int index) {
            return this.dataPoints[index];
        }
    }
}

