/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jfree.data.Series;
import org.jfree.data.SeriesException;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.util.ObjectUtils;

public class TimeSeries
extends Series
implements Cloneable,
Serializable {
    protected static final String DEFAULT_DOMAIN_DESCRIPTION = "Time";
    protected static final String DEFAULT_RANGE_DESCRIPTION = "Value";
    private String domain;
    private String range;
    protected Class timePeriodClass;
    protected List data;
    private int maximumItemCount;
    private int historyCount;
    static /* synthetic */ Class class$0;

    public TimeSeries(String name) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.Day");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this(name, DEFAULT_DOMAIN_DESCRIPTION, DEFAULT_RANGE_DESCRIPTION, clazz);
    }

    public TimeSeries(String name, Class timePeriodClass) {
        this(name, DEFAULT_DOMAIN_DESCRIPTION, DEFAULT_RANGE_DESCRIPTION, timePeriodClass);
    }

    public TimeSeries(String name, String domain, String range, Class timePeriodClass) {
        super(name);
        this.domain = domain;
        this.range = range;
        this.timePeriodClass = timePeriodClass;
        this.data = new ArrayList();
        this.maximumItemCount = Integer.MAX_VALUE;
        this.historyCount = 0;
    }

    public String getDomainDescription() {
        return this.domain;
    }

    public void setDomainDescription(String description) {
        String old = this.domain;
        this.domain = description;
        this.firePropertyChange("Domain", old, description);
    }

    public String getRangeDescription() {
        return this.range;
    }

    public void setRangeDescription(String description) {
        String old = this.range;
        this.range = description;
        this.firePropertyChange("Range", old, description);
    }

    public int getItemCount() {
        return this.data.size();
    }

    public List getItems() {
        return Collections.unmodifiableList(this.data);
    }

    public int getMaximumItemCount() {
        return this.maximumItemCount;
    }

    public void setMaximumItemCount(int maximum) {
        this.maximumItemCount = maximum;
        while (this.data.size() > this.maximumItemCount) {
            this.data.remove(0);
        }
    }

    public int getHistoryCount() {
        return this.historyCount;
    }

    public void setHistoryCount(int periods) {
        this.historyCount = periods;
    }

    public Class getTimePeriodClass() {
        return this.timePeriodClass;
    }

    public TimeSeriesDataItem getDataItem(int index) {
        return (TimeSeriesDataItem)this.data.get(index);
    }

    public TimeSeriesDataItem getDataItem(RegularTimePeriod period) {
        if (period == null) {
            throw new IllegalArgumentException("Null 'period' argument");
        }
        TimeSeriesDataItem dummy = new TimeSeriesDataItem(period, new Integer(0));
        int index = Collections.binarySearch(this.data, dummy);
        if (index >= 0) {
            return (TimeSeriesDataItem)this.data.get(index);
        }
        return null;
    }

    public RegularTimePeriod getTimePeriod(int index) {
        return this.getDataItem(index).getPeriod();
    }

    public RegularTimePeriod getNextTimePeriod() {
        RegularTimePeriod last = this.getTimePeriod(this.getItemCount() - 1);
        return last.next();
    }

    public Collection getTimePeriods() {
        ArrayList<RegularTimePeriod> result = new ArrayList<RegularTimePeriod>();
        int i = 0;
        while (i < this.getItemCount()) {
            result.add(this.getTimePeriod(i));
            ++i;
        }
        return result;
    }

    public Collection getTimePeriodsUniqueToOtherSeries(TimeSeries series) {
        ArrayList<RegularTimePeriod> result = new ArrayList<RegularTimePeriod>();
        int i = 0;
        while (i < series.getItemCount()) {
            RegularTimePeriod period = series.getTimePeriod(i);
            int index = this.getIndex(period);
            if (index < 0) {
                result.add(period);
            }
            ++i;
        }
        return result;
    }

    public int getIndex(RegularTimePeriod period) {
        if (period == null) {
            throw new IllegalArgumentException("Null 'period' argument.");
        }
        TimeSeriesDataItem dummy = new TimeSeriesDataItem(period, new Integer(0));
        int index = Collections.binarySearch(this.data, dummy);
        return index;
    }

    public Number getValue(int index) {
        return this.getDataItem(index).getValue();
    }

    public Number getValue(RegularTimePeriod period) {
        int index = this.getIndex(period);
        if (index >= 0) {
            return this.getValue(index);
        }
        return null;
    }

    public void add(TimeSeriesDataItem item) {
        if (item == null) {
            throw new IllegalArgumentException("Null 'item' argument.");
        }
        if (!item.getPeriod().getClass().equals(this.timePeriodClass)) {
            String message = "TimeSeries.add(): you are trying to add data where the time ";
            message = String.valueOf(message) + "period class is " + item.getPeriod().getClass().getName() + ", ";
            message = String.valueOf(message) + "but the TimeSeries is expecting an instance of " + this.timePeriodClass.getName() + ".";
            throw new SeriesException(message);
        }
        int index = Collections.binarySearch(this.data, item);
        if (index < 0) {
            this.data.add(-index - 1, item);
            if (this.getItemCount() > this.maximumItemCount) {
                this.data.remove(0);
            }
        } else {
            String message = "TimeSeries.add(): you are attempting to add an observation for ";
            message = String.valueOf(message) + "the time period " + item.getPeriod().toString() + " but the ";
            message = String.valueOf(message) + "series already contains an observation for that time period.  ";
            message = String.valueOf(message) + "Duplicates are not permitted.  Try using the addOrUpdate() method.";
            throw new SeriesException(message);
        }
        this.ageHistoryCountItems();
        this.fireSeriesChanged();
    }

    public void add(RegularTimePeriod period, double value) {
        TimeSeriesDataItem item = new TimeSeriesDataItem(period, value);
        this.add(item);
    }

    public void add(RegularTimePeriod period, Number value) {
        TimeSeriesDataItem item = new TimeSeriesDataItem(period, value);
        this.add(item);
    }

    public void update(RegularTimePeriod period, Number value) {
        TimeSeriesDataItem temp = new TimeSeriesDataItem(period, value);
        int index = Collections.binarySearch(this.data, temp);
        if (index < 0) {
            throw new SeriesException("TimeSeries.update(TimePeriod, Number):  period does not exist.");
        }
        TimeSeriesDataItem pair = (TimeSeriesDataItem)this.data.get(index);
        pair.setValue(value);
        this.fireSeriesChanged();
    }

    public void update(int index, Number value) {
        TimeSeriesDataItem item = this.getDataItem(index);
        item.setValue(value);
        this.fireSeriesChanged();
    }

    public TimeSeries addAndOrUpdate(TimeSeries series) {
        TimeSeries overwritten = new TimeSeries("Overwritten values from: " + this.getName());
        int i = 0;
        while (i < series.getItemCount()) {
            TimeSeriesDataItem pair = series.getDataItem(i);
            TimeSeriesDataItem oldPair = this.addOrUpdate(pair.getPeriod(), pair.getValue());
            if (oldPair != null) {
                try {
                    overwritten.add(oldPair);
                }
                catch (SeriesException e) {
                    System.err.println("TimeSeries.addAndOrUpdate(series): unable to add data to overwritten series.");
                }
            }
            ++i;
        }
        return overwritten;
    }

    public TimeSeriesDataItem addOrUpdate(RegularTimePeriod period, double value) {
        return this.addOrUpdate(period, new Double(value));
    }

    public TimeSeriesDataItem addOrUpdate(RegularTimePeriod period, Number value) {
        if (period == null) {
            throw new IllegalArgumentException("Null 'period' argument.");
        }
        TimeSeriesDataItem overwritten = null;
        TimeSeriesDataItem key = new TimeSeriesDataItem(period, value);
        int index = Collections.binarySearch(this.data, key);
        if (index >= 0) {
            TimeSeriesDataItem existing = (TimeSeriesDataItem)this.data.get(index);
            overwritten = (TimeSeriesDataItem)existing.clone();
            existing.setValue(value);
            this.ageHistoryCountItems();
            this.fireSeriesChanged();
        } else {
            this.data.add(-index - 1, new TimeSeriesDataItem(period, value));
            this.ageHistoryCountItems();
            this.fireSeriesChanged();
        }
        return overwritten;
    }

    public void ageHistoryCountItems() {
        if (this.getItemCount() > 1 && this.historyCount > 0) {
            long latest = this.getTimePeriod(this.getItemCount() - 1).getSerialIndex();
            while (latest - this.getTimePeriod(0).getSerialIndex() >= (long)this.historyCount) {
                this.data.remove(0);
            }
        }
    }

    public void ageHistoryCountItems(long latest) {
        if (this.getItemCount() > 1 && this.historyCount > 0) {
            while (latest - this.getTimePeriod(0).getSerialIndex() >= (long)this.historyCount) {
                this.data.remove(0);
            }
        }
    }

    public void clear() {
        if (this.data.size() > 0) {
            this.data.clear();
            this.fireSeriesChanged();
        }
    }

    public void delete(RegularTimePeriod period) {
        int index = this.getIndex(period);
        this.data.remove(index);
        this.fireSeriesChanged();
    }

    public void delete(int start, int end) {
        int i = 0;
        while (i <= end - start) {
            this.data.remove(start);
            ++i;
        }
        this.fireSeriesChanged();
    }

    public Object clone() throws CloneNotSupportedException {
        TimeSeries clone = this.createCopy(0, this.getItemCount() - 1);
        return clone;
    }

    public TimeSeries createCopy(int start, int end) throws CloneNotSupportedException {
        TimeSeries copy = (TimeSeries)super.clone();
        copy.data = new ArrayList();
        if (this.data.size() > 0) {
            int index = start;
            while (index <= end) {
                TimeSeriesDataItem item = (TimeSeriesDataItem)this.data.get(index);
                TimeSeriesDataItem clone = (TimeSeriesDataItem)item.clone();
                try {
                    copy.add(clone);
                }
                catch (SeriesException e) {
                    System.err.println("TimeSeries.createCopy(): unable to add cloned data item.");
                }
                ++index;
            }
        }
        return copy;
    }

    public TimeSeries createCopy(RegularTimePeriod start, RegularTimePeriod end) throws CloneNotSupportedException {
        int endIndex;
        int startIndex = this.getIndex(start);
        if (startIndex < 0) {
            startIndex = -(startIndex + 1);
        }
        if ((endIndex = this.getIndex(end)) < 0) {
            endIndex = -(endIndex + 1);
            --endIndex;
        }
        TimeSeries result = this.createCopy(startIndex, endIndex);
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TimeSeries) || !super.equals(object)) {
            return false;
        }
        TimeSeries s = (TimeSeries)object;
        if (!ObjectUtils.equal(this.getDomainDescription(), s.getDomainDescription())) {
            return false;
        }
        if (!ObjectUtils.equal(this.getRangeDescription(), s.getRangeDescription())) {
            return false;
        }
        if (!this.getClass().equals(s.getClass())) {
            return false;
        }
        if (this.getHistoryCount() != s.getHistoryCount()) {
            return false;
        }
        if (this.getMaximumItemCount() != s.getMaximumItemCount()) {
            return false;
        }
        int count = this.getItemCount();
        if (count != s.getItemCount()) {
            return false;
        }
        int i = 0;
        while (i < count) {
            if (!this.getDataItem(i).equals(s.getDataItem(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int result = this.domain != null ? this.domain.hashCode() : 0;
        result = 29 * result + (this.range != null ? this.range.hashCode() : 0);
        result = 29 * result + (this.timePeriodClass != null ? this.timePeriodClass.hashCode() : 0);
        result = 29 * result + this.data.hashCode();
        result = 29 * result + this.maximumItemCount;
        result = 29 * result + this.historyCount;
        return result;
    }

    public TimeSeriesDataItem getDataPair(int index) {
        return this.getDataItem(index);
    }

    public TimeSeriesDataItem getDataPair(RegularTimePeriod period) {
        return this.getDataItem(period);
    }
}

