/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.Day;

public class DayTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.junit.DayTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public DayTests(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testEqualsSelf() {
        Day day = new Day();
        Assert.assertTrue((boolean)day.equals(day));
    }

    public void testEquals() {
        Day day1 = new Day(29, 3, 2002);
        Day day2 = new Day(29, 3, 2002);
        Assert.assertTrue((boolean)day1.equals(day2));
    }

    public void testDateConstructor1() {
        TimeZone zone = TimeZone.getTimeZone("GMT");
        Day d1 = new Day(new Date(1078099199999L), zone);
        Day d2 = new Day(new Date(1078099200000L), zone);
        Assert.assertEquals((int)2, (int)d1.getMonth());
        Assert.assertEquals((long)1078099199999L, (long)d1.getLastMillisecond(zone));
        Assert.assertEquals((int)3, (int)d2.getMonth());
        Assert.assertEquals((long)1078099200000L, (long)d2.getFirstMillisecond(zone));
    }

    public void testDateConstructor2() {
        TimeZone zone = TimeZone.getTimeZone("Europe/Helsinki");
        Day d1 = new Day(new Date(1078091999999L), zone);
        Day d2 = new Day(new Date(1078092000000L), zone);
        Assert.assertEquals((int)2, (int)d1.getMonth());
        Assert.assertEquals((long)1078091999999L, (long)d1.getLastMillisecond(zone));
        Assert.assertEquals((int)3, (int)d2.getMonth());
        Assert.assertEquals((long)1078092000000L, (long)d2.getFirstMillisecond(zone));
    }

    public void test1Jan1900Previous() {
        Day jan1st1900 = new Day(1, 1, 1900);
        Day previous = (Day)jan1st1900.previous();
        Assert.assertNull((Object)previous);
    }

    public void test1Jan1900Next() {
        Day jan1st1900 = new Day(1, 1, 1900);
        Day next = (Day)jan1st1900.next();
        Assert.assertEquals((int)2, (int)next.getDayOfMonth());
    }

    public void test31Dec9999Previous() {
        Day dec31st9999 = new Day(31, 12, 9999);
        Day previous = (Day)dec31st9999.previous();
        Assert.assertEquals((int)30, (int)previous.getDayOfMonth());
    }

    public void test31Dec9999Next() {
        Day dec31st9999 = new Day(31, 12, 9999);
        Day next = (Day)dec31st9999.next();
        Assert.assertNull((Object)next);
    }

    public void testParseDay() throws ParseException {
        Day d;
        GregorianCalendar gc = new GregorianCalendar(2001, 12, 31);
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
        Date reference = format.parse("31/12/2001");
        if (reference.equals(gc.getTime())) {
            d = Day.parseDay("31/12/2001");
            Assert.assertEquals((int)37256, (int)d.getSerialDate().toSerial());
        }
        d = Day.parseDay("2001-12-31");
        Assert.assertEquals((int)37256, (int)d.getSerialDate().toSerial());
    }

    public void testSerialization() {
        Day d1 = new Day(15, 4, 2000);
        Day d2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(d1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            d2 = (Day)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)d1, d2);
    }

    public void testHashcode() {
        Day d1 = new Day(1, 2, 2003);
        Day d2 = new Day(1, 2, 2003);
        Assert.assertTrue((boolean)d1.equals(d2));
        int h1 = d1.hashCode();
        int h2 = d2.hashCode();
        Assert.assertEquals((int)h1, (int)h2);
    }
}

