/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;

public class HourTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.junit.HourTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public HourTests(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testEqualsSelf() {
        Hour hour = new Hour();
        Assert.assertTrue((boolean)hour.equals(hour));
    }

    public void testEquals() {
        Hour hour1 = new Hour(15, new Day(29, 3, 2002));
        Hour hour2 = new Hour(15, new Day(29, 3, 2002));
        Assert.assertTrue((boolean)hour1.equals(hour2));
    }

    public void testDateConstructor1() {
        TimeZone zone = TimeZone.getTimeZone("GMT");
        Hour h1 = new Hour(new Date(1014307199999L), zone);
        Hour h2 = new Hour(new Date(1014307200000L), zone);
        Assert.assertEquals((int)15, (int)h1.getHour());
        Assert.assertEquals((long)1014307199999L, (long)h1.getLastMillisecond(zone));
        Assert.assertEquals((int)16, (int)h2.getHour());
        Assert.assertEquals((long)1014307200000L, (long)h2.getFirstMillisecond(zone));
    }

    public void testDateConstructor2() {
        TimeZone zone = TimeZone.getTimeZone("Australia/Sydney");
        Hour h1 = new Hour(new Date(1014267599999L), zone);
        Hour h2 = new Hour(new Date(1014267600000L), zone);
        Assert.assertEquals((int)15, (int)h1.getHour());
        Assert.assertEquals((long)1014267599999L, (long)h1.getLastMillisecond(zone));
        Assert.assertEquals((int)16, (int)h2.getHour());
        Assert.assertEquals((long)1014267600000L, (long)h2.getFirstMillisecond(zone));
    }

    public void testFirstHourPrevious() {
        Hour first = new Hour(0, new Day(1, 1, 1900));
        Hour previous = (Hour)first.previous();
        Assert.assertNull((Object)previous);
    }

    public void testFirstHourNext() {
        Hour first = new Hour(0, new Day(1, 1, 1900));
        Hour next = (Hour)first.next();
        Assert.assertEquals((int)1, (int)next.getHour());
        Assert.assertEquals((int)1900, (int)next.getYear());
    }

    public void testLastHourPrevious() {
        Hour last = new Hour(23, new Day(31, 12, 9999));
        Hour previous = (Hour)last.previous();
        Assert.assertEquals((int)22, (int)previous.getHour());
        Assert.assertEquals((int)9999, (int)previous.getYear());
    }

    public void testLastHourNext() {
        Hour last = new Hour(23, new Day(31, 12, 9999));
        Hour next = (Hour)last.next();
        Assert.assertNull((Object)next);
    }

    public void testParseHour() {
        Hour h = Hour.parseHour("2002-01-29 13");
        Assert.assertEquals((int)13, (int)h.getHour());
    }

    public void testSerialization() {
        Hour h1 = new Hour();
        Hour h2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(h1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            h2 = (Hour)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)h1, h2);
    }

    public void testHashcode() {
        Hour h1 = new Hour(7, 9, 10, 1999);
        Hour h2 = new Hour(7, 9, 10, 1999);
        Assert.assertTrue((boolean)h1.equals(h2));
        int hash1 = h1.hashCode();
        int hash2 = h2.hashCode();
        Assert.assertEquals((int)hash1, (int)hash2);
    }
}

