/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;

public class MinuteTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.junit.MinuteTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public MinuteTests(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testEqualsSelf() {
        Minute minute = new Minute();
        Assert.assertTrue((boolean)minute.equals(minute));
    }

    public void testEquals() {
        Day day1 = new Day(29, 3, 2002);
        Hour hour1 = new Hour(15, day1);
        Minute minute1 = new Minute(15, hour1);
        Day day2 = new Day(29, 3, 2002);
        Hour hour2 = new Hour(15, day2);
        Minute minute2 = new Minute(15, hour2);
        Assert.assertTrue((boolean)minute1.equals(minute2));
    }

    public void testDateConstructor1() {
        TimeZone zone = TimeZone.getTimeZone("GMT");
        Minute m1 = new Minute(new Date(1016729699999L), zone);
        Minute m2 = new Minute(new Date(1016729700000L), zone);
        Assert.assertEquals((int)54, (int)m1.getMinute());
        Assert.assertEquals((long)1016729699999L, (long)m1.getLastMillisecond(zone));
        Assert.assertEquals((int)55, (int)m2.getMinute());
        Assert.assertEquals((long)1016729700000L, (long)m2.getFirstMillisecond(zone));
    }

    public void testDateConstructor2() {
        TimeZone zone = TimeZone.getTimeZone("Asia/Singapore");
        Minute m1 = new Minute(new Date(1016700899999L), zone);
        Minute m2 = new Minute(new Date(1016700900000L), zone);
        Assert.assertEquals((int)54, (int)m1.getMinute());
        Assert.assertEquals((long)1016700899999L, (long)m1.getLastMillisecond(zone));
        Assert.assertEquals((int)55, (int)m2.getMinute());
        Assert.assertEquals((long)1016700900000L, (long)m2.getFirstMillisecond(zone));
    }

    public void testSerialization() {
        Minute m1 = new Minute();
        Minute m2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(m1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            m2 = (Minute)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)m1, m2);
    }

    public void testHashcode() {
        Minute m1 = new Minute(45, 5, 1, 2, 2003);
        Minute m2 = new Minute(45, 5, 1, 2, 2003);
        Assert.assertTrue((boolean)m1.equals(m2));
        int h1 = m1.hashCode();
        int h2 = m2.hashCode();
        Assert.assertEquals((int)h1, (int)h2);
    }
}

