/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.Month;
import org.jfree.data.time.TimePeriodFormatException;

public class MonthTests
extends TestCase {
    private Month jan1900;
    private Month feb1900;
    private Month nov9999;
    private Month dec9999;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.junit.MonthTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public MonthTests(String name) {
        super(name);
    }

    protected void setUp() {
        this.jan1900 = new Month(1, 1900);
        this.feb1900 = new Month(2, 1900);
        this.nov9999 = new Month(11, 9999);
        this.dec9999 = new Month(12, 9999);
    }

    public void testEqualsSelf() {
        Month month = new Month();
        Assert.assertTrue((boolean)month.equals(month));
    }

    public void testEquals() {
        Month m1 = new Month(5, 2002);
        Month m2 = new Month(5, 2002);
        Assert.assertTrue((boolean)m1.equals(m2));
    }

    public void testDateConstructor1() {
        TimeZone zone = TimeZone.getTimeZone("GMT");
        Month m1 = new Month(new Date(951868799999L), zone);
        Month m2 = new Month(new Date(951868800000L), zone);
        Assert.assertEquals((int)2, (int)m1.getMonth());
        Assert.assertEquals((long)951868799999L, (long)m1.getLastMillisecond(zone));
        Assert.assertEquals((int)3, (int)m2.getMonth());
        Assert.assertEquals((long)951868800000L, (long)m2.getFirstMillisecond(zone));
    }

    public void testDateConstructor2() {
        TimeZone zone = TimeZone.getTimeZone("Pacific/Auckland");
        Month m1 = new Month(new Date(951821999999L), zone);
        Month m2 = new Month(new Date(951822000000L), zone);
        Assert.assertEquals((int)2, (int)m1.getMonth());
        Assert.assertEquals((long)951821999999L, (long)m1.getLastMillisecond(zone));
        Assert.assertEquals((int)3, (int)m2.getMonth());
        Assert.assertEquals((long)951822000000L, (long)m2.getFirstMillisecond(zone));
    }

    public void testJan1900Previous() {
        Month previous = (Month)this.jan1900.previous();
        Assert.assertNull((Object)previous);
    }

    public void testJan1900Next() {
        Month next = (Month)this.jan1900.next();
        Assert.assertEquals((Object)this.feb1900, (Object)next);
    }

    public void testDec9999Previous() {
        Month previous = (Month)this.dec9999.previous();
        Assert.assertEquals((Object)this.nov9999, (Object)previous);
    }

    public void testDec9999Next() {
        Month next = (Month)this.dec9999.next();
        Assert.assertNull((Object)next);
    }

    public void testParseMonth() {
        Month month = null;
        try {
            month = Month.parseMonth("1990-01");
        }
        catch (TimePeriodFormatException e) {
            month = new Month(1, 1900);
        }
        Assert.assertEquals((int)1, (int)month.getMonth());
        Assert.assertEquals((int)1990, (int)month.getYear().getYear());
        try {
            month = Month.parseMonth("02-1991");
        }
        catch (TimePeriodFormatException e) {
            month = new Month(1, 1900);
        }
        Assert.assertEquals((int)2, (int)month.getMonth());
        Assert.assertEquals((int)1991, (int)month.getYear().getYear());
        try {
            month = Month.parseMonth("March 1993");
        }
        catch (TimePeriodFormatException e) {
            month = new Month(1, 1900);
        }
        Assert.assertEquals((int)3, (int)month.getMonth());
        Assert.assertEquals((int)1993, (int)month.getYear().getYear());
    }

    public void testSerialization() {
        Month m1 = new Month(12, 1999);
        Month m2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(m1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            m2 = (Month)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)m1, m2);
    }

    public void testHashcode() {
        Month m1 = new Month(2, 2003);
        Month m2 = new Month(2, 2003);
        Assert.assertTrue((boolean)m1.equals(m2));
        int h1 = m1.hashCode();
        int h2 = m2.hashCode();
        Assert.assertEquals((int)h1, (int)h2);
    }
}

