/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.SeriesChangeEvent;
import org.jfree.data.SeriesChangeListener;
import org.jfree.data.SeriesException;
import org.jfree.data.time.Day;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.time.Year;

public class TimeSeriesTests
extends TestCase
implements SeriesChangeListener {
    private TimeSeries seriesA;
    private TimeSeries seriesB;
    private TimeSeries seriesC;
    private boolean gotSeriesChangeEvent = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.junit.TimeSeriesTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public TimeSeriesTests(String name) {
        super(name);
    }

    protected void setUp() {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.jfree.data.time.Year");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.seriesA = new TimeSeries("Series A", clazz3);
        try {
            this.seriesA.add((RegularTimePeriod)new Year(2000), new Integer(102000));
            this.seriesA.add((RegularTimePeriod)new Year(2001), new Integer(102001));
            this.seriesA.add((RegularTimePeriod)new Year(2002), new Integer(102002));
            this.seriesA.add((RegularTimePeriod)new Year(2003), new Integer(102003));
            this.seriesA.add((RegularTimePeriod)new Year(2004), new Integer(102004));
            this.seriesA.add((RegularTimePeriod)new Year(2005), new Integer(102005));
        }
        catch (SeriesException e) {
            System.err.println("TimeSeriesTests.setUp(): problem creating series.");
        }
        if ((clazz2 = class$1) == null) {
            try {
                clazz2 = class$1 = Class.forName("org.jfree.data.time.Year");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.seriesB = new TimeSeries("Series B", clazz2);
        try {
            this.seriesB.add((RegularTimePeriod)new Year(2006), new Integer(202006));
            this.seriesB.add((RegularTimePeriod)new Year(2007), new Integer(202007));
            this.seriesB.add((RegularTimePeriod)new Year(2008), new Integer(202008));
        }
        catch (SeriesException e) {
            System.err.println("TimeSeriesTests.setUp(): problem creating series.");
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("org.jfree.data.time.Year");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.seriesC = new TimeSeries("Series C", clazz);
        try {
            this.seriesC.add((RegularTimePeriod)new Year(1999), new Integer(301999));
            this.seriesC.add((RegularTimePeriod)new Year(2000), new Integer(302000));
            this.seriesC.add((RegularTimePeriod)new Year(2002), new Integer(302002));
        }
        catch (SeriesException e) {
            System.err.println("TimeSeriesTests.setUp(): problem creating series.");
        }
    }

    public void seriesChanged(SeriesChangeEvent event) {
        this.gotSeriesChangeEvent = true;
    }

    public void testClone() {
        TimeSeries series = new TimeSeries("Test Series");
        Day jan1st2002 = new Day(1, 1, 2002);
        try {
            series.add((RegularTimePeriod)jan1st2002, new Integer(42));
        }
        catch (SeriesException e) {
            System.err.println("TimeSeriesTests.testClone: problem adding to series.");
        }
        TimeSeries clone = null;
        try {
            clone = (TimeSeries)series.clone();
            clone.setName("Clone Series");
            try {
                clone.update(jan1st2002, (Number)new Integer(10));
            }
            catch (SeriesException e) {
                System.err.println("TimeSeriesTests.testClone: problem updating series.");
            }
        }
        catch (CloneNotSupportedException e) {
            Assert.assertTrue((boolean)false);
        }
        int seriesValue = series.getValue(jan1st2002).intValue();
        int cloneValue = clone.getValue(jan1st2002).intValue();
        Assert.assertEquals((int)42, (int)seriesValue);
        Assert.assertEquals((int)10, (int)cloneValue);
        Assert.assertEquals((String)"Test Series", (String)series.getName());
        Assert.assertEquals((String)"Clone Series", (String)clone.getName());
    }

    public void testAddValue() {
        try {
            this.seriesA.add((RegularTimePeriod)new Year(1999), new Integer(1));
        }
        catch (SeriesException e) {
            System.err.println("TimeSeriesTests.testAddValue: problem adding to series.");
        }
        int value = this.seriesA.getValue(0).intValue();
        Assert.assertEquals((int)1, (int)value);
    }

    public void testGetValue() {
        Number value1 = this.seriesA.getValue(new Year(1999));
        Assert.assertNull((Object)value1);
        int value2 = this.seriesA.getValue(new Year(2000)).intValue();
        Assert.assertEquals((int)102000, (int)value2);
    }

    public void testDelete() {
        this.seriesA.delete(0, 0);
        Assert.assertEquals((int)5, (int)this.seriesA.getItemCount());
        Number value = this.seriesA.getValue(new Year(2000));
        Assert.assertNull((Object)value);
    }

    public void testDelete2() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.jfree.data.time.Year");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TimeSeries s1 = new TimeSeries("Series", clazz);
        s1.add((RegularTimePeriod)new Year(2000), 13.75);
        s1.add((RegularTimePeriod)new Year(2001), 11.9);
        s1.add((RegularTimePeriod)new Year(2002), null);
        s1.addChangeListener(this);
        this.gotSeriesChangeEvent = false;
        s1.delete(new Year(2001));
        Assert.assertTrue((boolean)this.gotSeriesChangeEvent);
        Assert.assertEquals((int)2, (int)s1.getItemCount());
        Assert.assertEquals(null, (Object)s1.getValue(new Year(2001)));
    }

    public void testSerialization() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.jfree.data.time.Year");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TimeSeries s1 = new TimeSeries("A test", clazz);
        s1.add((RegularTimePeriod)new Year(2000), 13.75);
        s1.add((RegularTimePeriod)new Year(2001), 11.9);
        s1.add((RegularTimePeriod)new Year(2002), null);
        s1.add((RegularTimePeriod)new Year(2005), 19.32);
        s1.add((RegularTimePeriod)new Year(2007), 16.89);
        TimeSeries s2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(s1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            s2 = (TimeSeries)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertTrue((boolean)s1.equals(s2));
    }

    public void testEquals() {
        TimeSeries s1 = new TimeSeries("Time Series 1");
        TimeSeries s2 = new TimeSeries("Time Series 2");
        boolean b1 = s1.equals(s2);
        Assert.assertFalse((String)"b1", (boolean)b1);
        s2.setName("Time Series 1");
        boolean b2 = s1.equals(s2);
        Assert.assertTrue((String)"b2", (boolean)b2);
        Day p1 = new Day();
        RegularTimePeriod p2 = ((RegularTimePeriod)p1).next();
        s1.add((RegularTimePeriod)p1, 100.0);
        s1.add(p2, 200.0);
        boolean b3 = s1.equals(s2);
        Assert.assertFalse((String)"b3", (boolean)b3);
        s2.add((RegularTimePeriod)p1, 100.0);
        s2.add(p2, 200.0);
        boolean b4 = s1.equals(s2);
        Assert.assertTrue((String)"b4", (boolean)b4);
        s1.setMaximumItemCount(100);
        boolean b5 = s1.equals(s2);
        Assert.assertFalse((String)"b5", (boolean)b5);
        s2.setMaximumItemCount(100);
        boolean b6 = s1.equals(s2);
        Assert.assertTrue((String)"b6", (boolean)b6);
        s1.setHistoryCount(100);
        boolean b7 = s1.equals(s2);
        Assert.assertFalse((String)"b7", (boolean)b7);
        s2.setHistoryCount(100);
        boolean b8 = s1.equals(s2);
        Assert.assertTrue((String)"b8", (boolean)b8);
    }

    public void testEquals2() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.jfree.data.time.Day");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TimeSeries s1 = new TimeSeries("Series", null, null, clazz);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.jfree.data.time.Day");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TimeSeries s2 = new TimeSeries("Series", null, null, clazz2);
        Assert.assertTrue((boolean)s1.equals(s2));
    }

    public void testCreateCopy1() {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.jfree.data.time.Month");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TimeSeries series = new TimeSeries("Series", clazz);
        series.add((RegularTimePeriod)new Month(1, 2003), 45.0);
        series.add((RegularTimePeriod)new Month(2, 2003), 55.0);
        series.add((RegularTimePeriod)new Month(6, 2003), 35.0);
        series.add((RegularTimePeriod)new Month(11, 2003), 85.0);
        series.add((RegularTimePeriod)new Month(12, 2003), 75.0);
        try {
            TimeSeries result1 = series.createCopy(new Month(11, 2002), new Month(12, 2002));
            Assert.assertEquals((int)0, (int)result1.getItemCount());
            TimeSeries result2 = series.createCopy(new Month(11, 2002), new Month(1, 2003));
            Assert.assertEquals((int)1, (int)result2.getItemCount());
            TimeSeries result3 = series.createCopy(new Month(11, 2002), new Month(4, 2003));
            Assert.assertEquals((int)2, (int)result3.getItemCount());
            TimeSeries result4 = series.createCopy(new Month(11, 2002), new Month(12, 2003));
            Assert.assertEquals((int)5, (int)result4.getItemCount());
            TimeSeries result5 = series.createCopy(new Month(11, 2002), new Month(3, 2004));
            Assert.assertEquals((int)5, (int)result5.getItemCount());
            TimeSeries result6 = series.createCopy(new Month(1, 2003), new Month(1, 2003));
            Assert.assertEquals((int)1, (int)result6.getItemCount());
            TimeSeries result7 = series.createCopy(new Month(1, 2003), new Month(4, 2003));
            Assert.assertEquals((int)2, (int)result7.getItemCount());
            TimeSeries result8 = series.createCopy(new Month(1, 2003), new Month(12, 2003));
            Assert.assertEquals((int)5, (int)result8.getItemCount());
            TimeSeries result9 = series.createCopy(new Month(1, 2003), new Month(3, 2004));
            Assert.assertEquals((int)5, (int)result9.getItemCount());
            TimeSeries result10 = series.createCopy(new Month(5, 2003), new Month(12, 2003));
            Assert.assertEquals((int)3, (int)result10.getItemCount());
            TimeSeries result11 = series.createCopy(new Month(5, 2003), new Month(3, 2004));
            Assert.assertEquals((int)3, (int)result11.getItemCount());
            TimeSeries result12 = series.createCopy(new Month(12, 2003), new Month(12, 2003));
            Assert.assertEquals((int)1, (int)result12.getItemCount());
            TimeSeries result13 = series.createCopy(new Month(12, 2003), new Month(3, 2004));
            Assert.assertEquals((int)1, (int)result13.getItemCount());
            TimeSeries result14 = series.createCopy(new Month(1, 2004), new Month(3, 2004));
            Assert.assertEquals((int)0, (int)result14.getItemCount());
        }
        catch (CloneNotSupportedException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    public void testSetMaximumItemCount() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.jfree.data.time.Year");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TimeSeries s1 = new TimeSeries("S1", clazz);
        s1.add((RegularTimePeriod)new Year(2000), 13.75);
        s1.add((RegularTimePeriod)new Year(2001), 11.9);
        s1.add((RegularTimePeriod)new Year(2002), null);
        s1.add((RegularTimePeriod)new Year(2005), 19.32);
        s1.add((RegularTimePeriod)new Year(2007), 16.89);
        Assert.assertTrue((s1.getItemCount() == 5 ? 1 : 0) != 0);
        s1.setMaximumItemCount(3);
        Assert.assertTrue((s1.getItemCount() == 3 ? 1 : 0) != 0);
        TimeSeriesDataItem item = s1.getDataItem(0);
        Assert.assertTrue((boolean)item.getPeriod().equals(new Year(2002)));
    }
}

