/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.Week;

public class WeekTests
extends TestCase {
    private Week w1Y1900;
    private Week w2Y1900;
    private Week w51Y9999;
    private Week w52Y9999;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.junit.WeekTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public WeekTests(String name) {
        super(name);
    }

    protected void setUp() {
        this.w1Y1900 = new Week(1, 1900);
        this.w2Y1900 = new Week(2, 1900);
        this.w51Y9999 = new Week(51, 9999);
        this.w52Y9999 = new Week(52, 9999);
    }

    public void testEquals() {
        Week w1 = new Week(1, 2002);
        Week w2 = new Week(1, 2002);
        Assert.assertTrue((boolean)w1.equals(w2));
        Assert.assertTrue((boolean)w2.equals(w1));
        w1 = new Week(2, 2002);
        Assert.assertFalse((boolean)w1.equals(w2));
        w2 = new Week(2, 2002);
        Assert.assertTrue((boolean)w1.equals(w2));
        w1 = new Week(2, 2003);
        Assert.assertFalse((boolean)w1.equals(w2));
        w2 = new Week(2, 2003);
        Assert.assertTrue((boolean)w1.equals(w2));
    }

    public void testW1Y1900Previous() {
        Week previous = (Week)this.w1Y1900.previous();
        Assert.assertNull((Object)previous);
    }

    public void testW1Y1900Next() {
        Week next = (Week)this.w1Y1900.next();
        Assert.assertEquals((Object)this.w2Y1900, (Object)next);
    }

    public void testW52Y9999Previous() {
        Week previous = (Week)this.w52Y9999.previous();
        Assert.assertEquals((Object)this.w51Y9999, (Object)previous);
    }

    public void testW52Y9999Next() {
        Week next = (Week)this.w52Y9999.next();
        Assert.assertNull((Object)next);
    }

    public void testSerialization() {
        Week w1 = new Week(24, 1999);
        Week w2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(w1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            w2 = (Week)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)w1, w2);
    }

    public void testHashcode() {
        Week w1 = new Week(2, 2003);
        Week w2 = new Week(2, 2003);
        Assert.assertTrue((boolean)w1.equals(w2));
        int h1 = w1.hashCode();
        int h2 = w2.hashCode();
        Assert.assertEquals((int)h1, (int)h2);
    }

    public void testWeek12005() {
        Week w1 = new Week(1, 2005);
        Calendar c1 = Calendar.getInstance(TimeZone.getTimeZone("Europe/London"), Locale.UK);
        Assert.assertEquals((long)1104105600000L, (long)w1.getFirstMillisecond(c1));
        Assert.assertEquals((long)1104710399999L, (long)w1.getLastMillisecond(c1));
        Calendar c2 = Calendar.getInstance(TimeZone.getTimeZone("Europe/Paris"), Locale.FRANCE);
        Assert.assertEquals((long)1104102000000L, (long)w1.getFirstMillisecond(c2));
        Assert.assertEquals((long)1104706799999L, (long)w1.getLastMillisecond(c2));
        Calendar c3 = Calendar.getInstance(TimeZone.getTimeZone("America/New_York"), Locale.US);
        Assert.assertEquals((long)1104037200000L, (long)w1.getFirstMillisecond(c3));
        Assert.assertEquals((long)1104641999999L, (long)w1.getLastMillisecond(c3));
    }

    public void testWeek532005() {
        Week w1 = new Week(53, 2005);
        Calendar c1 = Calendar.getInstance(TimeZone.getTimeZone("Europe/London"), Locale.UK);
        Assert.assertEquals((long)1135555200000L, (long)w1.getFirstMillisecond(c1));
        Assert.assertEquals((long)1135555200000L, (long)w1.getLastMillisecond(c1));
        Calendar c2 = Calendar.getInstance(TimeZone.getTimeZone("Europe/Paris"), Locale.FRANCE);
        Assert.assertEquals((long)1135551600000L, (long)w1.getFirstMillisecond(c2));
        Assert.assertEquals((long)1135551600000L, (long)w1.getLastMillisecond(c2));
        Calendar c3 = Calendar.getInstance(TimeZone.getTimeZone("America/New_York"), Locale.US);
        Assert.assertEquals((long)1135486800000L, (long)w1.getFirstMillisecond(c3));
        Assert.assertEquals((long)1136091599999L, (long)w1.getLastMillisecond(c3));
    }
}

