/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.io.junit;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.io.SerialUtilities;

public class SerialUtilitiesTests
extends TestCase {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.io.junit.SerialUtilitiesTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public SerialUtilitiesTests(String name) {
        super(name);
    }

    public void testIsSerializable() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.awt.Color");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Assert.assertTrue((boolean)SerialUtilities.isSerializable(clazz));
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("java.awt.GradientPaint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Assert.assertFalse((boolean)SerialUtilities.isSerializable(clazz2));
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("java.awt.TexturePaint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Assert.assertFalse((boolean)SerialUtilities.isSerializable(clazz3));
    }

    public void testColorSerialization() {
        Color p1 = Color.blue;
        Paint p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            SerialUtilities.writePaint(p1, out);
            out.close();
            ByteArrayInputStream bias = new ByteArrayInputStream(buffer.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bias);
            p2 = SerialUtilities.readPaint(in);
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)p1, p2);
    }

    public void testGradientPaintSerialization() {
        GradientPaint p1 = new GradientPaint(0.0f, 0.0f, Color.blue, 100.0f, 200.0f, Color.red);
        Paint p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            SerialUtilities.writePaint(p1, out);
            out.close();
            ByteArrayInputStream bias = new ByteArrayInputStream(buffer.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bias);
            p2 = SerialUtilities.readPaint(in);
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        GradientPaint gp1 = p1;
        GradientPaint gp2 = (GradientPaint)p2;
        Assert.assertEquals((Object)gp1.getColor1(), (Object)gp2.getColor1());
        Assert.assertEquals((Object)gp1.getPoint1(), (Object)gp2.getPoint1());
        Assert.assertEquals((Object)gp1.getColor2(), (Object)gp2.getColor2());
        Assert.assertEquals((Object)gp1.getPoint2(), (Object)gp2.getPoint2());
        Assert.assertEquals((boolean)gp1.isCyclic(), (boolean)gp2.isCyclic());
    }

    public void testTexturePaintSerialization() {
        TexturePaint p1 = new TexturePaint(new BufferedImage(5, 5, 1), new Rectangle2D.Double(0.0, 0.0, 5.0, 5.0));
        Paint p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            SerialUtilities.writePaint(p1, out);
            out.close();
            ByteArrayInputStream bias = new ByteArrayInputStream(buffer.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bias);
            p2 = SerialUtilities.readPaint(in);
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertNull(p2);
    }
}

