/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class LCBLayout
implements LayoutManager,
Serializable {
    private static final int COLUMNS = 3;
    private int[] colWidth = new int[3];
    private int[] rowHeight;
    private int labelGap = 10;
    private int buttonGap = 6;
    private int vGap = 2;

    public LCBLayout(int maxrows) {
        this.rowHeight = new int[maxrows];
    }

    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int r;
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = ncomponents / 3;
            int c = 0;
            while (c < 3) {
                r = 0;
                while (r < nrows) {
                    Component component = parent.getComponent(r * 3 + c);
                    Dimension d = component.getPreferredSize();
                    if (this.colWidth[c] < d.width) {
                        this.colWidth[c] = d.width;
                    }
                    if (this.rowHeight[r] < d.height) {
                        this.rowHeight[r] = d.height;
                    }
                    ++r;
                }
                ++c;
            }
            int totalHeight = this.vGap * (nrows - 1);
            r = 0;
            while (r < nrows) {
                totalHeight += this.rowHeight[r];
                ++r;
            }
            int totalWidth = this.colWidth[0] + this.labelGap + this.colWidth[1] + this.buttonGap + this.colWidth[2];
            return new Dimension(insets.left + insets.right + totalWidth + this.labelGap + this.buttonGap, insets.top + insets.bottom + totalHeight + this.vGap);
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int r;
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = ncomponents / 3;
            int c = 0;
            while (c < 3) {
                r = 0;
                while (r < nrows) {
                    Component component = parent.getComponent(r * 3 + c);
                    Dimension d = component.getMinimumSize();
                    if (this.colWidth[c] < d.width) {
                        this.colWidth[c] = d.width;
                    }
                    if (this.rowHeight[r] < d.height) {
                        this.rowHeight[r] = d.height;
                    }
                    ++r;
                }
                ++c;
            }
            int totalHeight = this.vGap * (nrows - 1);
            r = 0;
            while (r < nrows) {
                totalHeight += this.rowHeight[r];
                ++r;
            }
            int totalWidth = this.colWidth[0] + this.labelGap + this.colWidth[1] + this.buttonGap + this.colWidth[2];
            return new Dimension(insets.left + insets.right + totalWidth + this.labelGap + this.buttonGap, insets.top + insets.bottom + totalHeight + this.vGap);
        }
    }

    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int r;
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = ncomponents / 3;
            int c = 0;
            while (c < 3) {
                r = 0;
                while (r < nrows) {
                    Component component = parent.getComponent(r * 3 + c);
                    Dimension d = component.getPreferredSize();
                    if (this.colWidth[c] < d.width) {
                        this.colWidth[c] = d.width;
                    }
                    if (this.rowHeight[r] < d.height) {
                        this.rowHeight[r] = d.height;
                    }
                    ++r;
                }
                ++c;
            }
            int totalHeight = this.vGap * (nrows - 1);
            r = 0;
            while (r < nrows) {
                totalHeight += this.rowHeight[r];
                ++r;
            }
            int totalWidth = this.colWidth[0] + this.colWidth[1] + this.colWidth[2];
            int available = parent.getWidth() - insets.left - insets.right - this.labelGap - this.buttonGap;
            this.colWidth[1] = this.colWidth[1] + (available - totalWidth);
            int x = insets.left;
            int c2 = 0;
            while (c2 < 3) {
                int y = insets.top;
                int r2 = 0;
                while (r2 < nrows) {
                    int i = r2 * 3 + c2;
                    if (i < ncomponents) {
                        Component component = parent.getComponent(i);
                        Dimension d = component.getPreferredSize();
                        int h = d.height;
                        int adjust = (this.rowHeight[r2] - h) / 2;
                        parent.getComponent(i).setBounds(x, y + adjust, this.colWidth[c2], h);
                    }
                    y = y + this.rowHeight[r2] + this.vGap;
                    ++r2;
                }
                x += this.colWidth[c2];
                if (c2 == 0) {
                    x += this.labelGap;
                }
                if (c2 == 1) {
                    x += this.buttonGap;
                }
                ++c2;
            }
        }
    }

    public void addLayoutComponent(Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(String name, Component comp) {
    }
}

