/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.text;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jfree.text.TextBlockAnchor;
import org.jfree.text.TextLine;
import org.jfree.ui.Size2D;
import org.jfree.ui.TextAnchor;
import org.jfree.util.Log;
import org.jfree.util.LogContext;
import org.jfree.util.ShapeUtils;

public class TextBlock
implements Serializable {
    private List lines = new ArrayList();
    protected static final LogContext logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.text.TextBlock");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Log.createContext(clazz);
    }

    public void addLine(String text, Font font, Paint paint) {
        this.addLine(new TextLine(text, font, paint));
    }

    public void addLine(TextLine line) {
        this.lines.add(line);
    }

    public TextLine getLastLine() {
        TextLine last = null;
        int index = this.lines.size() - 1;
        if (index >= 0) {
            last = (TextLine)this.lines.get(index);
        }
        return last;
    }

    public List getLines() {
        return Collections.unmodifiableList(this.lines);
    }

    public Size2D calculateDimensions(Graphics2D g2) {
        double width = 0.0;
        double height = 0.0;
        Iterator iterator = this.lines.iterator();
        while (iterator.hasNext()) {
            TextLine line = (TextLine)iterator.next();
            Size2D dimension = line.calculateDimensions(g2);
            width = Math.max(width, dimension.getWidth());
            height += dimension.getHeight();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("width = " + width + ", height = " + height);
        }
        return new Size2D(width, height);
    }

    public Shape calculateBounds(Graphics2D g2, float anchorX, float anchorY, TextBlockAnchor anchor, float rotateX, float rotateY, double angle) {
        Size2D d = this.calculateDimensions(g2);
        float[] offsets = this.calculateOffsets(anchor, d.getWidth(), d.getHeight());
        Rectangle2D.Double bounds = new Rectangle2D.Double(anchorX + offsets[0], anchorY + offsets[1], d.getWidth(), d.getHeight());
        Shape rotatedBounds = ShapeUtils.rotateShape(bounds, angle, rotateX, rotateY);
        return rotatedBounds;
    }

    public void draw(Graphics2D g2, float x, float y, TextBlockAnchor anchor) {
        this.draw(g2, x, y, anchor, 0.0f, 0.0f, 0.0);
    }

    public void draw(Graphics2D g2, float anchorX, float anchorY, TextBlockAnchor anchor, float rotateX, float rotateY, double angle) {
        Size2D d = this.calculateDimensions(g2);
        float[] offsets = this.calculateOffsets(anchor, d.getWidth(), d.getHeight());
        Iterator iterator = this.lines.iterator();
        float yCursor = 0.0f;
        while (iterator.hasNext()) {
            TextLine line = (TextLine)iterator.next();
            line.draw(g2, anchorX + offsets[0], anchorY + offsets[1] + yCursor, TextAnchor.TOP_LEFT, rotateX, rotateY, angle);
            Size2D dimension = line.calculateDimensions(g2);
            yCursor += (float)dimension.getHeight();
        }
    }

    private float[] calculateOffsets(TextBlockAnchor anchor, double width, double height) {
        float[] result = new float[2];
        float xAdj = 0.0f;
        float yAdj = 0.0f;
        if (anchor == TextBlockAnchor.TOP_CENTER || anchor == TextBlockAnchor.CENTER || anchor == TextBlockAnchor.BOTTOM_CENTER) {
            xAdj = (float)(-width) / 2.0f;
        } else if (anchor == TextBlockAnchor.TOP_RIGHT || anchor == TextBlockAnchor.CENTER_RIGHT || anchor == TextBlockAnchor.BOTTOM_RIGHT) {
            xAdj = (float)(-width);
        }
        if (anchor == TextBlockAnchor.TOP_LEFT || anchor == TextBlockAnchor.TOP_CENTER || anchor == TextBlockAnchor.TOP_RIGHT) {
            yAdj = 0.0f;
        } else if (anchor == TextBlockAnchor.CENTER_LEFT || anchor == TextBlockAnchor.CENTER || anchor == TextBlockAnchor.CENTER_RIGHT) {
            yAdj = (float)(-height) / 2.0f;
        } else if (anchor == TextBlockAnchor.BOTTOM_LEFT || anchor == TextBlockAnchor.BOTTOM_CENTER || anchor == TextBlockAnchor.BOTTOM_RIGHT) {
            yAdj = (float)(-height);
        }
        result[0] = xAdj;
        result[1] = yAdj;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof TextBlock) {
            TextBlock block = (TextBlock)obj;
            return this.lines.equals(block.lines);
        }
        return false;
    }
}

