/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.text.junit;

import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.text.TextFragment;

public class TextFragmentTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.text.junit.TextFragmentTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public TextFragmentTests(String name) {
        super(name);
    }

    public void testEquals() {
        TextFragment tf1 = new TextFragment("Test");
        TextFragment tf2 = new TextFragment("Test");
        Assert.assertTrue((boolean)tf1.equals(tf2));
        Assert.assertTrue((boolean)tf2.equals(tf1));
        tf1 = new TextFragment("Test 1");
        Assert.assertFalse((boolean)tf1.equals(tf2));
        tf2 = new TextFragment("Test 1");
        Assert.assertTrue((boolean)tf1.equals(tf2));
        tf1 = new TextFragment("Test 1", new Font("Arial", 1, 11));
        Assert.assertFalse((boolean)tf1.equals(tf2));
        tf2 = new TextFragment("Test 1", new Font("Arial", 1, 11));
        Assert.assertTrue((boolean)tf1.equals(tf2));
        tf1 = new TextFragment("Test 1", new Font("Arial", 1, 11), Color.red);
        Assert.assertFalse((boolean)tf1.equals(tf2));
        tf2 = new TextFragment("Test 1", new Font("Arial", 1, 11), Color.red);
        Assert.assertTrue((boolean)tf1.equals(tf2));
    }

    public void testSerialization() {
        TextFragment tf1 = new TextFragment("Test");
        TextFragment tf2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(tf1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            tf2 = (TextFragment)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)tf1, tf2);
    }
}

