/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class Spacer
implements Serializable {
    public static final int RELATIVE = 0;
    public static final int ABSOLUTE = 1;
    private int type;
    private double left;
    private double right;
    private double top;
    private double bottom;

    public Spacer(int type, double left, double top, double right, double bottom) {
        this.type = type;
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }

    public double getLeftSpace(double width) {
        double result = 0.0;
        if (this.type == 1) {
            result = this.left;
        } else if (this.type == 0) {
            result = this.left * width;
        }
        return result;
    }

    public double getRightSpace(double width) {
        double result = 0.0;
        if (this.type == 1) {
            result = this.right;
        } else if (this.type == 0) {
            result = this.right * width;
        }
        return result;
    }

    public double getTopSpace(double height) {
        double result = 0.0;
        if (this.type == 1) {
            result = this.top;
        } else if (this.type == 0) {
            result = this.top * height;
        }
        return result;
    }

    public double getBottomSpace(double height) {
        double result = 0.0;
        if (this.type == 1) {
            result = this.bottom;
        } else if (this.type == 0) {
            result = this.bottom * height;
        }
        return result;
    }

    public double getAdjustedWidth(double width) {
        double result = width;
        if (this.type == 1) {
            result = result + this.left + this.right;
        } else if (this.type == 0) {
            result = result + this.left * width + this.right * width;
        }
        return result;
    }

    public double getAdjustedHeight(double height) {
        double result = height;
        if (this.type == 1) {
            result = result + this.top + this.bottom;
        } else if (this.type == 0) {
            result = result + this.top * height + this.bottom * height;
        }
        return result;
    }

    public void trim(Rectangle2D area) {
        double x = area.getX();
        double y = area.getY();
        double h = area.getHeight();
        double w = area.getWidth();
        double l = this.getLeftSpace(w);
        double r = this.getRightSpace(w);
        double t = this.getTopSpace(h);
        double b = this.getBottomSpace(h);
        area.setRect(x + l, y + t, w - l - r, h - t - b);
    }

    public double trimWidth(double w) {
        return w - this.getLeftSpace(w) - this.getRightSpace(w);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Spacer) {
            boolean b4;
            Spacer s = (Spacer)obj;
            boolean b0 = this.type == s.type;
            boolean b1 = this.left == s.left;
            boolean b2 = this.right == s.right;
            boolean b3 = this.top == s.top;
            boolean bl = b4 = this.bottom == s.bottom;
            return b0 && b1 && b2 && b3 && b4;
        }
        return false;
    }
}

