/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.UnitType;

public class RectangleInsetsTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.ui.junit.RectangleInsetsTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public RectangleInsetsTests(String name) {
        super(name);
    }

    public void testEquals() {
        RectangleInsets i1 = new RectangleInsets(UnitType.ABSOLUTE, 1.0, 2.0, 3.0, 4.0);
        RectangleInsets i2 = new RectangleInsets(UnitType.ABSOLUTE, 1.0, 2.0, 3.0, 4.0);
        Assert.assertTrue((boolean)i1.equals(i2));
        Assert.assertTrue((boolean)i2.equals(i1));
        i1 = new RectangleInsets(UnitType.RELATIVE, 1.0, 2.0, 3.0, 4.0);
        Assert.assertFalse((boolean)i1.equals(i2));
        i2 = new RectangleInsets(UnitType.RELATIVE, 1.0, 2.0, 3.0, 4.0);
        Assert.assertTrue((boolean)i1.equals(i2));
        i1 = new RectangleInsets(UnitType.RELATIVE, 0.0, 2.0, 3.0, 4.0);
        Assert.assertFalse((boolean)i1.equals(i2));
        i2 = new RectangleInsets(UnitType.RELATIVE, 0.0, 2.0, 3.0, 4.0);
        Assert.assertTrue((boolean)i1.equals(i2));
        i1 = new RectangleInsets(UnitType.RELATIVE, 0.0, 0.0, 3.0, 4.0);
        Assert.assertFalse((boolean)i1.equals(i2));
        i2 = new RectangleInsets(UnitType.RELATIVE, 0.0, 0.0, 3.0, 4.0);
        Assert.assertTrue((boolean)i1.equals(i2));
        i1 = new RectangleInsets(UnitType.RELATIVE, 0.0, 0.0, 0.0, 4.0);
        Assert.assertFalse((boolean)i1.equals(i2));
        i2 = new RectangleInsets(UnitType.RELATIVE, 0.0, 0.0, 0.0, 4.0);
        Assert.assertTrue((boolean)i1.equals(i2));
        i1 = new RectangleInsets(UnitType.RELATIVE, 0.0, 0.0, 0.0, 0.0);
        Assert.assertFalse((boolean)i1.equals(i2));
        i2 = new RectangleInsets(UnitType.RELATIVE, 0.0, 0.0, 0.0, 0.0);
        Assert.assertTrue((boolean)i1.equals(i2));
    }

    public void testSerialization() {
        RectangleInsets i1 = new RectangleInsets(UnitType.ABSOLUTE, 1.0, 2.0, 3.0, 4.0);
        RectangleInsets i2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(i1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            i2 = (RectangleInsets)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertTrue((boolean)i1.equals(i2));
    }
}

