/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui.tabbedui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.ui.tabbedui.RootEditor;

public abstract class AbstractTabbedGUI
extends JFrame {
    private ArrayList rootEditors;
    private JTabbedPane tabbedPane;
    private int selectedRootEditor = -1;
    private JComponent currentToolbar;
    private JPanel toolbarContainer;
    private Action closeAction;

    public AbstractTabbedGUI() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AbstractTabbedGUI.this.getCloseAction().actionPerformed(new ActionEvent(this, 1001, null, 0));
            }
        });
        this.toolbarContainer = new JPanel();
        this.tabbedPane = new JTabbedPane(3);
        this.tabbedPane.addChangeListener(new TabChangeHandler(this.tabbedPane));
        this.rootEditors = new ArrayList();
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.toolbarContainer, "North");
        contentPane.add((Component)this.tabbedPane, "Center");
        this.setContentPane(contentPane);
        this.closeAction = this.createCloseAction();
    }

    protected void initComponents() {
        JMenuBar menuBar = new JMenuBar();
        this.addMenus(menuBar, this.getPrefixMenus());
        this.addMenus(menuBar, this.getPostfixMenus());
        this.setJMenuBar(menuBar);
    }

    protected Action createCloseAction() {
        return new ExitAction();
    }

    public Action getCloseAction() {
        return this.closeAction;
    }

    protected abstract JMenu[] getPrefixMenus();

    protected abstract JMenu[] getPostfixMenus();

    private void addMenus(JMenuBar menuBar, JMenu[] customMenus) {
        int i = 0;
        while (i < customMenus.length) {
            menuBar.add(customMenus[i]);
            ++i;
        }
    }

    private JMenuBar createEditorMenubar(RootEditor root) {
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar == null) {
            menuBar = new JMenuBar();
        } else {
            menuBar.removeAll();
        }
        this.addMenus(menuBar, this.getPrefixMenus());
        this.addMenus(menuBar, root.getMenus());
        this.addMenus(menuBar, this.getPostfixMenus());
        return menuBar;
    }

    public void addRootEditor(RootEditor rootPanel) {
        this.rootEditors.add(rootPanel);
        this.tabbedPane.add(rootPanel.getEditorName(), rootPanel.getMainPanel());
        if (this.rootEditors.size() == 0) {
            this.setSelectedEditor(0);
        }
    }

    public RootEditor getRootEditor(int pos) {
        return (RootEditor)this.rootEditors.get(pos);
    }

    public int getSelectedEditor() {
        return this.selectedRootEditor;
    }

    public void setSelectedEditor(int selectedEditor) {
        RootEditor container;
        boolean shouldBeActive;
        int oldEditor = this.selectedRootEditor;
        if (oldEditor == selectedEditor) {
            return;
        }
        this.selectedRootEditor = selectedEditor;
        int i = 0;
        while (i < this.rootEditors.size()) {
            shouldBeActive = i == selectedEditor;
            container = (RootEditor)this.rootEditors.get(i);
            if (container.isActive() && !shouldBeActive) {
                container.setActive(false);
            }
            ++i;
        }
        if (this.currentToolbar != null) {
            this.closeToolbar();
            this.toolbarContainer.removeAll();
            this.currentToolbar = null;
        }
        i = 0;
        while (i < this.rootEditors.size()) {
            shouldBeActive = i == selectedEditor;
            container = (RootEditor)this.rootEditors.get(i);
            if (!container.isActive() && shouldBeActive) {
                container.setActive(true);
                this.setJMenuBar(this.createEditorMenubar(container));
                this.currentToolbar = container.getToolbar();
                if (this.currentToolbar != null) {
                    this.toolbarContainer.add((Component)this.currentToolbar, "Center");
                    this.toolbarContainer.setVisible(true);
                    this.currentToolbar.setVisible(true);
                } else {
                    this.toolbarContainer.setVisible(false);
                }
            }
            ++i;
        }
    }

    private void closeToolbar() {
        if (this.currentToolbar != null) {
            Window w;
            if (this.currentToolbar.getParent() != this.toolbarContainer && (w = SwingUtilities.windowForComponent(this.currentToolbar)) != null) {
                w.setVisible(false);
                w.dispose();
            }
            this.currentToolbar.setVisible(false);
        }
    }

    protected abstract void attempExit();

    protected class ExitAction
    extends AbstractAction {
        public ExitAction() {
            this.putValue("Name", "Exit");
        }

        public void actionPerformed(ActionEvent e) {
            AbstractTabbedGUI.this.attempExit();
        }
    }

    private class TabChangeHandler
    implements ChangeListener {
        private final JTabbedPane pane;

        public TabChangeHandler(JTabbedPane pane) {
            this.pane = pane;
        }

        public void stateChanged(ChangeEvent e) {
            AbstractTabbedGUI.this.setSelectedEditor(this.pane.getSelectedIndex());
        }
    }
}

