/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util.junit;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.util.ObjectTable;
import org.jfree.util.PaintTable;

public class ObjectTableTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.util.junit.ObjectTableTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public ObjectTableTests(String name) {
        super(name);
    }

    public void testCreate() {
        TObjectTable t = new TObjectTable();
        Assert.assertEquals((int)t.getColumnCount(), (int)0);
        Assert.assertEquals((int)t.getRowCount(), (int)0);
        Assert.assertNull((Object)t.getObject(0, 0));
        Assert.assertNull((Object)t.getObject(12, 12));
    }

    public void testSetObject1() {
        TObjectTable t = new TObjectTable();
        t.setObject(8, 5, Color.red);
        Assert.assertEquals((int)6, (int)t.getColumnCount());
        Assert.assertEquals((int)9, (int)t.getRowCount());
        Assert.assertNull((Object)t.getObject(7, 4));
        Assert.assertEquals((Object)Color.red, (Object)t.getObject(8, 5));
    }

    public void testSerialization() {
        PaintTable t1 = new PaintTable();
        t1.setPaint(0, 0, Color.blue);
        t1.setPaint(0, 1, Color.red);
        t1.setPaint(1, 0, Color.yellow);
        t1.setPaint(1, 1, Color.green);
        ObjectTable t2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(t1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            t2 = (ObjectTable)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)t1, t2);
    }

    public class TObjectTable
    extends ObjectTable {
        public Object getObject(int row, int column) {
            return super.getObject(row, column);
        }

        public void setObject(int row, int column, Object object) {
            super.setObject(row, column, object);
        }
    }
}

