/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml;

import java.util.HashMap;
import java.util.Stack;
import org.jfree.util.Configuration;
import org.jfree.util.DefaultConfiguration;
import org.jfree.xml.CommentHandler;
import org.jfree.xml.ElementDefinitionHandler;
import org.jfree.xml.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class Parser
extends DefaultHandler
implements Configuration {
    public static final String CONTENTBASE_KEY = "content-base";
    private Stack activeFactories = new Stack();
    private ElementDefinitionHandler initialFactory;
    private DefaultConfiguration parserConfiguration = new DefaultConfiguration();
    private HashMap parserHelperObjects = new HashMap();
    private Locator locator;
    private final CommentHandler commentHandler = new CommentHandler();

    public CommentHandler getCommentHandler() {
        return this.commentHandler;
    }

    public String[] getComments() {
        return this.getCommentHandler().getComments();
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void pushFactory(ElementDefinitionHandler factory) {
        this.activeFactories.push(factory);
    }

    public ElementDefinitionHandler peekFactory() {
        return (ElementDefinitionHandler)this.activeFactories.peek();
    }

    public ElementDefinitionHandler popFactory() {
        this.activeFactories.pop();
        return this.peekFactory();
    }

    public void endDocument() throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.activeFactories.clear();
        this.pushFactory(this.getInitialFactory());
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.peekFactory().characters(ch, start, length);
        }
        catch (ParseException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ParseException(e, this.getLocator());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            try {
                this.peekFactory().endElement(qName);
            }
            catch (ParseException pe) {
                throw pe;
            }
            catch (Exception e) {
                throw new ParseException(e, this.getLocator());
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.getCommentHandler().clearComments();
            throw throwable;
        }
        {
            Object var5_8 = null;
            this.getCommentHandler().clearComments();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            try {
                this.peekFactory().startElement(qName, attributes);
            }
            catch (ParseException pe) {
                throw pe;
            }
            catch (Exception e) {
                throw new ParseException(e, this.getLocator());
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.getCommentHandler().clearComments();
            throw throwable;
        }
        {
            Object var6_9 = null;
            this.getCommentHandler().clearComments();
            return;
        }
    }

    public void setInitialFactory(ElementDefinitionHandler factory) {
        this.initialFactory = factory;
    }

    public ElementDefinitionHandler getInitialFactory() {
        return this.initialFactory;
    }

    public String getConfigProperty(String key) {
        return this.getConfigProperty(key, null);
    }

    public String getConfigProperty(String key, String defaultValue) {
        return this.parserConfiguration.getConfigProperty(key, defaultValue);
    }

    public void setConfigProperty(String key, String value) {
        if (value == null) {
            this.parserConfiguration.remove(key);
        } else {
            this.parserConfiguration.setProperty(key, value);
        }
    }

    public void setHelperObject(String key, Object value) {
        if (value == null) {
            this.parserHelperObjects.remove(key);
        } else {
            this.parserHelperObjects.put(key, value);
        }
    }

    public Object getHelperObject(String key) {
        return this.parserHelperObjects.get(key);
    }

    public abstract Parser getInstance();

    public abstract Object getResult();
}

