/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.TreeSet;
import org.jfree.util.Log;
import org.jfree.xml.factory.objects.AbstractObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;

public class BeanObjectDescription
extends AbstractObjectDescription {
    private TreeSet ignoredParameters = new TreeSet();

    public BeanObjectDescription(Class className) {
        this(className, true);
    }

    public BeanObjectDescription(Class className, boolean init) {
        super(className);
        if (!init) {
            return;
        }
        Method[] methods = this.getObjectClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            Method m = methods[i];
            if (Modifier.isPublic(m.getModifiers()) && !Modifier.isStatic(m.getModifiers()) && m.getParameterTypes().length == 1 && m.getName().startsWith("set")) {
                try {
                    String propertyName = this.getPropertyName(m.getName());
                    this.findGetMethod(propertyName, m.getParameterTypes()[0]);
                    this.setParameterDefinition(propertyName, m.getParameterTypes()[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    public Object createObject() {
        try {
            Object o = this.getObjectClass().newInstance();
            Iterator it = this.getParameterNames();
            while (it.hasNext()) {
                String name = (String)it.next();
                if (this.isParameterIgnored(name)) continue;
                Method method = this.findSetMethod(name);
                Object parameterValue = this.getParameter(name);
                if (parameterValue == null) continue;
                method.invoke(o, parameterValue);
            }
            return o;
        }
        catch (Exception e) {
            Log.error("Unable to invoke bean method", e);
            return null;
        }
    }

    private Method findSetMethod(String parameterName) throws NoSuchMethodException {
        return this.getObjectClass().getMethod(this.getSetterName(parameterName), this.getParameterDefinition(parameterName));
    }

    private Method findGetMethod(String parameterName, Class retval) throws NoSuchMethodException {
        return this.getObjectClass().getMethod(this.getGetterName(parameterName, retval), new Class[0]);
    }

    private String getSetterName(String parameterName) {
        if (parameterName.length() == 0) {
            return "set";
        }
        StringBuffer b = new StringBuffer();
        b.append("set");
        b.append(Character.toUpperCase(parameterName.charAt(0)));
        if (parameterName.length() > 1) {
            b.append(parameterName.substring(1));
        }
        return b.toString();
    }

    private String getGetterName(String parameterName, Class retval) {
        String prefix = "get";
        if (Boolean.TYPE.equals(retval)) {
            prefix = "is";
        }
        if (parameterName.length() == 0) {
            return prefix;
        }
        StringBuffer b = new StringBuffer();
        b.append(prefix);
        b.append(Character.toUpperCase(parameterName.charAt(0)));
        if (parameterName.length() > 1) {
            b.append(parameterName.substring(1));
        }
        return b.toString();
    }

    private String getPropertyName(String methodName) {
        if (methodName.length() < 3) {
            throw new IllegalArgumentException();
        }
        if (methodName.length() == 3) {
            return "";
        }
        StringBuffer b = new StringBuffer();
        b.append(Character.toLowerCase(methodName.charAt(3)));
        if (methodName.length() > 4) {
            b.append(methodName.substring(4));
        }
        return b.toString();
    }

    public void setParameterFromObject(Object o) throws ObjectFactoryException {
        if (o == null) {
            throw new NullPointerException("Given object is null");
        }
        Class c = this.getObjectClass();
        if (!c.isInstance(o)) {
            throw new ObjectFactoryException("Object is no instance of " + c + "(is " + o.getClass() + ")");
        }
        Iterator it = this.getParameterNames();
        while (it.hasNext()) {
            String propertyName = (String)it.next();
            if (this.isParameterIgnored(propertyName)) continue;
            try {
                Class parameter = this.getParameterDefinition(propertyName);
                Method method = this.findGetMethod(propertyName, parameter);
                Object retval = method.invoke(o, new Object[0]);
                if (retval == null) continue;
                this.setParameter(propertyName, retval);
            }
            catch (Exception e) {
                Log.info("Exception on method invokation.", e);
            }
        }
    }

    protected void ignoreParameter(String parameter) {
        this.ignoredParameters.add(parameter);
    }

    protected boolean isParameterIgnored(String parameter) {
        return this.ignoredParameters.contains(parameter);
    }
}

