/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.writer.coretypes;

import java.io.IOException;
import java.util.ArrayList;
import org.jfree.util.Log;
import org.jfree.xml.util.AttributeDefinition;
import org.jfree.xml.util.GenericObjectFactory;
import org.jfree.xml.util.ObjectDescriptionException;
import org.jfree.xml.util.PropertyDefinition;
import org.jfree.xml.writer.AbstractXmlWriteHandler;
import org.jfree.xml.writer.AttributeList;
import org.jfree.xml.writer.RootXmlWriteHandler;
import org.jfree.xml.writer.XMLWriter;
import org.jfree.xml.writer.XMLWriterException;

public class GenericWriteHandler
extends AbstractXmlWriteHandler {
    private GenericObjectFactory factory;

    public GenericWriteHandler(GenericObjectFactory factory) {
        this.factory = factory;
    }

    public void write(String tagName, Object object, XMLWriter writer, String mPlexAttribute, String mPlexValue) throws IOException, XMLWriterException {
        try {
            this.factory.readProperties(object);
            AttributeList attributes = new AttributeList();
            if (mPlexAttribute != null) {
                attributes.setAttribute(mPlexAttribute, mPlexValue);
            }
            AttributeDefinition[] attribDefs = this.factory.getAttributeDefinitions();
            ArrayList<String> properties = new ArrayList<String>();
            int i = 0;
            while (i < attribDefs.length) {
                AttributeDefinition adef = attribDefs[i];
                String pName = adef.getAttributeName();
                Object propValue = this.factory.getProperty(adef.getPropertyName());
                if (propValue != null) {
                    Log.debug("Here: " + this.factory.getBaseClass() + " -> " + adef.getPropertyName());
                    String value = adef.getHandler().toAttributeValue(propValue);
                    if (value != null) {
                        attributes.setAttribute(pName, value);
                    }
                }
                properties.add(adef.getPropertyName());
                ++i;
            }
            writer.writeTag(tagName, attributes, false);
            writer.startBlock();
            PropertyDefinition[] propertyDefs = this.factory.getPropertyDefinitions();
            RootXmlWriteHandler rootHandler = this.getRootHandler();
            int i2 = 0;
            while (i2 < propertyDefs.length) {
                PropertyDefinition pDef = propertyDefs[i2];
                String elementName = pDef.getElementName();
                rootHandler.write(elementName, this.factory.getProperty(pDef.getPropertyName()), this.factory.getTypeForTagName(elementName), writer);
                ++i2;
            }
            writer.endBlock();
            writer.writeCloseTag(tagName);
        }
        catch (ObjectDescriptionException ode) {
            Log.warn("Unable to write element", ode);
            throw new IOException(ode.getMessage());
        }
    }
}

