/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultGraphSelectionModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.Edge;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphSelectionModel;
import org.jgraph.graph.Port;
import org.jgraph.graph.PortView;
import org.jgraph.graph.VertexView;
import org.jgraph.plaf.GraphUI;
import org.jgraph.plaf.basic.BasicGraphUI;

public class JGraph
extends JComponent
implements CellViewFactory,
Scrollable,
Accessible,
Serializable {
    public static final String VERSION = "@NAME@ (v@VERSION@)";
    public static final int DOT_GRID_MODE = 0;
    public static final int CROSS_GRID_MODE = 1;
    public static final int LINE_GRID_MODE = 2;
    private static final String uiClassID = "GraphUI";
    protected transient GraphSelectionRedirector selectionRedirector;
    protected transient GraphModel graphModel;
    protected transient GraphLayoutCache graphLayoutCache;
    protected transient BasicMarqueeHandler marquee;
    protected transient GraphSelectionModel selectionModel;
    protected double scale = 1.0;
    protected boolean antiAliased = false;
    protected boolean editable = true;
    protected boolean gridVisible = false;
    protected double gridSize = 10.0;
    protected int gridMode = 0;
    protected boolean portsVisible = false;
    protected boolean moveBelowZero = false;
    protected Color highlightColor = Color.green;
    protected Color handleColor;
    protected Color lockedHandleColor;
    protected Color marqueeColor;
    protected Color gridColor;
    protected boolean dragEnabled = false;
    protected boolean dropEnabled = true;
    protected int editClickCount = 2;
    protected boolean enabled = true;
    protected boolean gridEnabled = false;
    protected int handleSize = 3;
    protected int tolerance = 4;
    protected int minimumMove = 5;
    protected boolean selectNewCells = false;
    protected boolean disconnectOnMove = false;
    protected boolean moveable = true;
    protected boolean cloneable = false;
    protected boolean sizeable = true;
    protected boolean bendable = true;
    protected boolean connectable = true;
    protected boolean disconnectable = true;
    protected boolean invokesStopCellEditing;
    private boolean settingUI;
    public static final String GRAPH_MODEL_PROPERTY = "model";
    public static final String GRAPH_LAYOUT_CACHE_PROPERTY = "view";
    public static final String MARQUEE_HANDLER_PROPERTY = "marquee";
    public static final String EDITABLE_PROPERTY = "editable";
    public static final String SCALE_PROPERTY = "scale";
    public static final String ANTIALIASED_PROPERTY = "antiAliased";
    public static final String GRID_SIZE_PROPERTY = "gridSize";
    public static final String GRID_VISIBLE_PROPERTY = "gridVisible";
    public static final String PORTS_VISIBLE_PROPERTY = "portsVisible";
    public static final String SELECTION_MODEL_PROPERTY = "selectionModel";
    public static final String INVOKES_STOP_CELL_EDITING_PROPERTY = "invokesStopCellEditing";
    static /* synthetic */ Class class$0;

    protected static GraphLayoutCache createDefaultGraphView(JGraph graph) {
        return new GraphLayoutCache(graph);
    }

    public static void addSampleData(GraphModel model) {
        ConnectionSet cs = new ConnectionSet();
        Hashtable<DefaultGraphCell, Map> attributes = new Hashtable<DefaultGraphCell, Map>();
        AttributeMap implementStyle = model.createAttributes();
        GraphConstants.setLineBegin(implementStyle, 2);
        GraphConstants.setBeginSize(implementStyle, 10);
        GraphConstants.setDashPattern(implementStyle, new float[]{3.0f, 3.0f});
        GraphConstants.setFont(implementStyle, GraphConstants.DEFAULTFONT.deriveFont(10));
        AttributeMap extendStyle = model.createAttributes();
        GraphConstants.setLineBegin(extendStyle, 2);
        GraphConstants.setBeginFill(extendStyle, true);
        GraphConstants.setBeginSize(extendStyle, 10);
        GraphConstants.setFont(extendStyle, GraphConstants.DEFAULTFONT.deriveFont(10));
        AttributeMap aggregateStyle = model.createAttributes();
        GraphConstants.setLineBegin(aggregateStyle, 9);
        GraphConstants.setBeginFill(aggregateStyle, true);
        GraphConstants.setBeginSize(aggregateStyle, 6);
        GraphConstants.setLineEnd(aggregateStyle, 4);
        GraphConstants.setEndSize(aggregateStyle, 8);
        GraphConstants.setLabelPosition(aggregateStyle, new Point(500, 1200));
        GraphConstants.setFont(aggregateStyle, GraphConstants.DEFAULTFONT.deriveFont(10));
        DefaultGraphCell gm = new DefaultGraphCell("GraphModel");
        attributes.put(gm, JGraph.createBounds(model.createAttributes(), 20, 100, Color.blue));
        gm.add(new DefaultPort("GraphModel/Center"));
        DefaultGraphCell dgm = new DefaultGraphCell("DefaultGraphModel");
        attributes.put(dgm, JGraph.createBounds(model.createAttributes(), 20, 180, Color.blue));
        dgm.add(new DefaultPort("DefaultGraphModel/Center"));
        DefaultEdge dgmImplementsGm = new DefaultEdge("implements");
        cs.connect((Object)dgmImplementsGm, (Object)gm.getChildAt(0), dgm.getChildAt(0));
        attributes.put(dgmImplementsGm, implementStyle);
        DefaultGraphCell modelGroup = new DefaultGraphCell("ModelGroup");
        modelGroup.add(gm);
        modelGroup.add(dgm);
        modelGroup.add(dgmImplementsGm);
        DefaultGraphCell jc = new DefaultGraphCell("JComponent");
        attributes.put(jc, JGraph.createBounds(model.createAttributes(), 150, 20, Color.green));
        jc.add(new DefaultPort("JComponent/Center"));
        DefaultGraphCell jg = new DefaultGraphCell("JGraph");
        attributes.put(jg, JGraph.createBounds(model.createAttributes(), 150, 100, Color.green));
        jg.add(new DefaultPort("JGraph/Center"));
        DefaultEdge jgExtendsJc = new DefaultEdge("extends");
        cs.connect((Object)jgExtendsJc, (Object)jc.getChildAt(0), jg.getChildAt(0));
        attributes.put(jgExtendsJc, extendStyle);
        DefaultGraphCell cu = new DefaultGraphCell("ComponentUI");
        attributes.put(cu, JGraph.createBounds(model.createAttributes(), 280, 20, Color.red));
        cu.add(new DefaultPort("ComponentUI/Center"));
        DefaultGraphCell gu = new DefaultGraphCell(uiClassID);
        attributes.put(gu, JGraph.createBounds(model.createAttributes(), 280, 100, Color.red));
        gu.add(new DefaultPort("GraphUI/Center"));
        DefaultGraphCell dgu = new DefaultGraphCell("BasicGraphUI");
        attributes.put(dgu, JGraph.createBounds(model.createAttributes(), 280, 180, Color.red));
        dgu.add(new DefaultPort("BasicGraphUI/Center"));
        DefaultEdge guExtendsCu = new DefaultEdge("extends");
        cs.connect((Object)guExtendsCu, (Object)cu.getChildAt(0), gu.getChildAt(0));
        attributes.put(guExtendsCu, extendStyle);
        DefaultEdge dguImplementsDu = new DefaultEdge("implements");
        cs.connect((Object)dguImplementsDu, (Object)gu.getChildAt(0), dgu.getChildAt(0));
        attributes.put(dguImplementsDu, implementStyle);
        DefaultGraphCell uiGroup = new DefaultGraphCell("UIGroup");
        uiGroup.add(cu);
        uiGroup.add(gu);
        uiGroup.add(dgu);
        uiGroup.add(dguImplementsDu);
        uiGroup.add(guExtendsCu);
        DefaultEdge jgAggregatesGm = new DefaultEdge(GRAPH_MODEL_PROPERTY);
        cs.connect((Object)jgAggregatesGm, (Object)jg.getChildAt(0), gm.getChildAt(0));
        attributes.put(jgAggregatesGm, aggregateStyle);
        DefaultEdge jcAggregatesCu = new DefaultEdge("ui");
        cs.connect((Object)jcAggregatesCu, (Object)jc.getChildAt(0), cu.getChildAt(0));
        attributes.put(jcAggregatesCu, aggregateStyle);
        Object[] cells = new Object[]{jgAggregatesGm, jcAggregatesCu, modelGroup, jc, jg, jgExtendsJc, uiGroup};
        model.insert(cells, attributes, cs, null, null);
    }

    public static Map createBounds(AttributeMap map, int x, int y, Color c) {
        GraphConstants.setBounds(map, map.createRect(x, y, 90.0, 30.0));
        GraphConstants.setBorder(map, BorderFactory.createRaisedBevelBorder());
        GraphConstants.setBackground(map, c.darker());
        GraphConstants.setForeground(map, Color.white);
        GraphConstants.setFont(map, GraphConstants.DEFAULTFONT.deriveFont(1, 12.0f));
        GraphConstants.setOpaque(map, true);
        return map;
    }

    public JGraph() {
        this(null);
    }

    public JGraph(GraphModel model) {
        this(model, (GraphLayoutCache)null);
    }

    public JGraph(GraphModel model, GraphLayoutCache view) {
        this(model, view, new BasicMarqueeHandler());
    }

    public JGraph(GraphModel model, BasicMarqueeHandler mh) {
        this(model, null, mh);
    }

    public JGraph(GraphModel model, GraphLayoutCache view, BasicMarqueeHandler mh) {
        this.selectionModel = new DefaultGraphSelectionModel(this);
        this.setLayout(null);
        this.marquee = mh;
        if (view == null) {
            view = JGraph.createDefaultGraphView(this);
        }
        this.setGraphLayoutCache(view);
        this.updateUI();
        if (model == null) {
            model = new DefaultGraphModel();
            this.setModel(model);
            JGraph.addSampleData(model);
        } else {
            this.setModel(model);
        }
        this.setDoubleBuffered(true);
    }

    public GraphUI getUI() {
        return (GraphUI)this.ui;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setUI(GraphUI ui) {
        if ((GraphUI)this.ui == ui) return;
        this.settingUI = true;
        try {
            super.setUI(ui);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.settingUI = false;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.settingUI = false;
            return;
        }
    }

    public void updateUI() {
        this.setUI(new BasicGraphUI());
        this.invalidate();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public Object[] getRoots() {
        return DefaultGraphModel.getRoots(this.graphModel);
    }

    public Object[] getRoots(Rectangle clip) {
        CellView[] views = this.graphLayoutCache.getRoots(clip);
        Object[] cells = new Object[views.length];
        int i = 0;
        while (i < views.length) {
            cells[i] = views[i].getCell();
            ++i;
        }
        return cells;
    }

    public Object[] getDescendants(Object[] cells) {
        Set set = DefaultGraphModel.getDescendants(this.getModel(), cells);
        return set.toArray();
    }

    public Object[] getDescendantList(Object[] cells) {
        return DefaultGraphModel.getDescendantList(this.getModel(), cells).toArray();
    }

    public Map cloneCells(Object[] cells) {
        return this.graphModel.cloneCells(cells);
    }

    public Object getFirstCellForLocation(double x, double y) {
        return this.getNextCellForLocation(null, x, y);
    }

    public Object getNextCellForLocation(Object current, double x, double y) {
        CellView cur = this.graphLayoutCache.getMapping(current, false);
        CellView cell = this.getNextViewAt(cur, x /= this.scale, y /= this.scale);
        if (cell != null) {
            return cell.getCell();
        }
        return null;
    }

    public Rectangle2D getCellBounds(Object cell) {
        CellView view = this.graphLayoutCache.getMapping(cell, false);
        if (view != null) {
            return view.getBounds();
        }
        return null;
    }

    public Rectangle2D getCellBounds(Object[] cells) {
        if (cells != null && cells.length > 0) {
            Rectangle2D r = this.getCellBounds(cells[0]);
            Rectangle2D ret = r != null ? (Rectangle2D)r.clone() : null;
            int i = 1;
            while (i < cells.length) {
                r = this.getCellBounds(cells[i]);
                if (r != null) {
                    if (ret == null) {
                        ret = r;
                    } else {
                        Rectangle2D.union(ret, r, ret);
                    }
                }
                ++i;
            }
            return ret;
        }
        return null;
    }

    public CellView getNextViewAt(CellView current, double x, double y) {
        Object[] sel = this.graphLayoutCache.order(this.getSelectionModel().getSelectables());
        CellView[] cells = this.graphLayoutCache.getMapping(sel);
        CellView cell = this.getNextViewAt(cells, current, x, y);
        return cell;
    }

    public CellView getNextViewAt(CellView[] cells, CellView c, double x, double y) {
        if (cells != null) {
            Rectangle2D.Double r = new Rectangle2D.Double(x - (double)this.tolerance, y - (double)this.tolerance, 2 * this.tolerance, 2 * this.tolerance);
            CellView first = null;
            boolean active = c == null;
            Graphics g = this.getGraphics();
            int i = cells.length - 1;
            while (i >= 0) {
                if (cells[i] != null && cells[i].intersects(g, r)) {
                    if (active && !this.selectionModel.isChildrenSelected(cells[i].getCell())) {
                        return cells[i];
                    }
                    if (first == null) {
                        first = cells[i];
                    }
                    active |= cells[i] == c;
                }
                --i;
            }
            return first;
        }
        return null;
    }

    public Object getPortForLocation(double x, double y) {
        PortView view = this.getPortViewAt(x, y);
        if (view != null) {
            return view.getCell();
        }
        return null;
    }

    public PortView getPortViewAt(double x, double y) {
        Rectangle2D.Double r = new Rectangle2D.Double(x - (double)this.tolerance, y - (double)this.tolerance, 2 * this.tolerance, 2 * this.tolerance);
        PortView[] ports = this.graphLayoutCache.getPorts();
        int i = ports.length - 1;
        while (i >= 0) {
            if (ports[i] != null && ports[i].intersects(this.getGraphics(), r)) {
                return ports[i];
            }
            --i;
        }
        return null;
    }

    public String convertValueToString(Object value) {
        CellView view;
        CellView cellView = view = value instanceof CellView ? (CellView)value : this.getGraphLayoutCache().getMapping(value, false);
        if (view != null) {
            Object newValue = GraphConstants.getValue(view.getAllAttributes());
            value = newValue != null ? newValue : view.getCell();
        }
        if (value instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)value).getUserObject() != null) {
            return ((DefaultMutableTreeNode)value).getUserObject().toString();
        }
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public Point2D snap(Point2D p) {
        if (this.gridEnabled && p != null) {
            double sgs = this.gridSize * this.getScale();
            p.setLocation(Math.round((double)Math.round(p.getX() / sgs) * sgs), Math.round((double)Math.round(p.getY() / sgs) * sgs));
        }
        return p;
    }

    public Dimension2D snap(Dimension2D d) {
        if (this.gridEnabled && d != null) {
            double sgs = this.gridSize * this.getScale();
            d.setSize(1L + Math.round((double)Math.round(d.getWidth() / sgs) * sgs), 1L + Math.round((double)Math.round(d.getHeight() / sgs) * sgs));
        }
        return d;
    }

    public Point2D toScreen(Point2D p) {
        if (p == null) {
            return null;
        }
        p.setLocation(Math.round(p.getX() * this.scale), (double)Math.round(p.getY()) * this.scale);
        return p;
    }

    public Point2D fromScreen(Point2D p) {
        if (p == null) {
            return null;
        }
        p.setLocation(Math.round(p.getX() / this.scale), (double)Math.round(p.getY()) / this.scale);
        return p;
    }

    public Rectangle2D toScreen(Rectangle2D rect) {
        if (rect == null) {
            return null;
        }
        rect.setFrame(rect.getX() * this.scale, rect.getY() * this.scale, rect.getWidth() * this.scale, rect.getHeight() * this.scale);
        return rect;
    }

    public Rectangle2D fromScreen(Rectangle2D rect) {
        if (rect == null) {
            return null;
        }
        rect.setFrame(rect.getX() / this.scale, rect.getY() / this.scale, rect.getWidth() / this.scale, rect.getHeight() / this.scale);
        return rect;
    }

    public CellView createView(JGraph graph, CellMapper mapper, Object cell) {
        AbstractCellView view = null;
        view = graph.getModel().isPort(cell) ? this.createPortView(graph, mapper, cell) : (graph.getModel().isEdge(cell) ? this.createEdgeView(graph, mapper, cell) : this.createVertexView(graph, mapper, cell));
        mapper.putMapping(cell, view);
        view.refresh(true);
        view.update();
        return view;
    }

    public void updateAutoSize(JGraph graph, CellView view) {
        Rectangle2D bounds;
        if (view != null && !graph.isEditing() && GraphConstants.isAutoSize(view.getAllAttributes()) && (bounds = view.getBounds()) != null) {
            Dimension2D d = graph.getUI().getPreferredSize(graph, view);
            bounds.setFrame(bounds.getX(), bounds.getY(), d.getWidth(), d.getHeight());
        }
    }

    protected EdgeView createEdgeView(JGraph graph, CellMapper mapper, Object cell) {
        if (cell instanceof Edge) {
            return this.createEdgeView(graph, mapper, (Edge)cell);
        }
        return new EdgeView(cell, graph, mapper);
    }

    protected PortView createPortView(JGraph graph, CellMapper mapper, Object cell) {
        if (cell instanceof Port) {
            return this.createPortView(graph, mapper, (Port)cell);
        }
        return new PortView(cell, graph, mapper);
    }

    protected EdgeView createEdgeView(JGraph graph, CellMapper mapper, Edge cell) {
        return new EdgeView(cell, graph, mapper);
    }

    protected PortView createPortView(JGraph graph, CellMapper mapper, Port cell) {
        return new PortView(cell, graph, mapper);
    }

    protected VertexView createVertexView(JGraph graph, CellMapper mapper, Object cell) {
        return new VertexView(cell, graph, mapper);
    }

    public int getEditClickCount() {
        return this.editClickCount;
    }

    public void setEditClickCount(int count) {
        this.editClickCount = count;
    }

    public boolean isDropEnabled() {
        return this.dropEnabled;
    }

    public void setDropEnabled(boolean flag) {
        this.dropEnabled = flag;
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean flag) {
        this.dragEnabled = flag;
    }

    public boolean isMoveable() {
        return this.moveable;
    }

    public void setMoveable(boolean flag) {
        this.moveable = flag;
    }

    public boolean isBendable() {
        return this.bendable;
    }

    public void setBendable(boolean flag) {
        this.bendable = flag;
    }

    public boolean isConnectable() {
        return this.connectable;
    }

    public void setConnectable(boolean flag) {
        this.connectable = flag;
    }

    public boolean isDisconnectable() {
        return this.disconnectable;
    }

    public void setDisconnectable(boolean flag) {
        this.disconnectable = flag;
    }

    public boolean isCloneable() {
        return this.cloneable;
    }

    public void setCloneable(boolean flag) {
        this.cloneable = flag;
    }

    public boolean isSizeable() {
        return this.sizeable;
    }

    public void setSizeable(boolean flag) {
        this.sizeable = flag;
    }

    public boolean isDisconnectOnMove() {
        return this.disconnectOnMove && this.disconnectable;
    }

    public void setSelectNewCells(boolean flag) {
        this.selectNewCells = flag;
    }

    public boolean isSelectNewCells() {
        return this.selectNewCells;
    }

    public void setDisconnectOnMove(boolean flag) {
        this.disconnectOnMove = flag;
    }

    public boolean isGridEnabled() {
        return this.gridEnabled;
    }

    public void setGridEnabled(boolean flag) {
        this.gridEnabled = flag;
    }

    public boolean isMoveBelowZero() {
        return this.moveBelowZero;
    }

    public void setMoveBelowZero(boolean moveBelowZero) {
        this.moveBelowZero = moveBelowZero;
    }

    public int getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(int size) {
        this.tolerance = size;
    }

    public int getHandleSize() {
        return this.handleSize;
    }

    public void setHandleSize(int size) {
        this.handleSize = size;
    }

    public int getMinimumMove() {
        return this.minimumMove;
    }

    public void setMinimumMove(int pixels) {
        this.minimumMove = pixels;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color newColor) {
        this.gridColor = newColor;
    }

    public Color getHandleColor() {
        return this.handleColor;
    }

    public void setHandleColor(Color newColor) {
        this.handleColor = newColor;
    }

    public Color getLockedHandleColor() {
        return this.lockedHandleColor;
    }

    public void setLockedHandleColor(Color newColor) {
        this.lockedHandleColor = newColor;
    }

    public Color getMarqueeColor() {
        return this.marqueeColor;
    }

    public void setMarqueeColor(Color newColor) {
        this.marqueeColor = newColor;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color newColor) {
        this.highlightColor = newColor;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double newValue) {
        if (newValue > 0.0) {
            double oldValue = this.scale;
            this.scale = newValue;
            this.firePropertyChange(SCALE_PROPERTY, oldValue, newValue);
        }
    }

    public double getGridSize() {
        return this.gridSize;
    }

    public int getGridMode() {
        return this.gridMode;
    }

    public void setGridSize(double newSize) {
        double oldValue = this.gridSize;
        this.gridSize = newSize;
        this.firePropertyChange(GRID_SIZE_PROPERTY, oldValue, newSize);
    }

    public void setGridMode(int mode) {
        if (mode == 0 || mode == 1 || mode == 2) {
            this.gridMode = mode;
            this.repaint();
        }
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setGridVisible(boolean flag) {
        boolean oldValue = this.gridVisible;
        this.gridVisible = flag;
        this.firePropertyChange(GRID_VISIBLE_PROPERTY, oldValue, flag);
    }

    public boolean isPortsVisible() {
        return this.portsVisible;
    }

    public void setPortsVisible(boolean flag) {
        boolean oldValue = this.portsVisible;
        this.portsVisible = flag;
        this.firePropertyChange(PORTS_VISIBLE_PROPERTY, oldValue, flag);
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public void setAntiAliased(boolean newValue) {
        boolean oldValue = this.antiAliased;
        this.antiAliased = newValue;
        this.firePropertyChange(ANTIALIASED_PROPERTY, oldValue, newValue);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean flag) {
        boolean oldValue = this.editable;
        this.editable = flag;
        this.firePropertyChange(EDITABLE_PROPERTY, oldValue, flag);
    }

    public GraphModel getModel() {
        return this.graphModel;
    }

    public void setModel(GraphModel newModel) {
        GraphModel oldModel = this.graphModel;
        this.graphModel = newModel;
        this.firePropertyChange(GRAPH_MODEL_PROPERTY, oldModel, this.graphModel);
        if (this.graphLayoutCache != null && this.graphLayoutCache.getModel() != this.graphModel) {
            this.graphLayoutCache.setModel(this.graphModel);
        }
        this.invalidate();
    }

    public GraphLayoutCache getGraphLayoutCache() {
        return this.graphLayoutCache;
    }

    public void setGraphLayoutCache(GraphLayoutCache newLayoutCache) {
        GraphLayoutCache oldLayoutCache = this.graphLayoutCache;
        this.graphLayoutCache = newLayoutCache;
        this.firePropertyChange(GRAPH_LAYOUT_CACHE_PROPERTY, oldLayoutCache, this.graphLayoutCache);
        if (this.graphLayoutCache != null && this.graphLayoutCache.getModel() != this.getModel()) {
            this.graphLayoutCache.setModel(this.getModel());
        }
        this.invalidate();
    }

    public BasicMarqueeHandler getMarqueeHandler() {
        return this.marquee;
    }

    public void setMarqueeHandler(BasicMarqueeHandler newMarquee) {
        BasicMarqueeHandler oldMarquee = this.marquee;
        this.marquee = newMarquee;
        this.firePropertyChange(MARQUEE_HANDLER_PROPERTY, oldMarquee, newMarquee);
        this.invalidate();
    }

    public void setInvokesStopCellEditing(boolean newValue) {
        boolean oldValue = this.invokesStopCellEditing;
        this.invokesStopCellEditing = newValue;
        this.firePropertyChange(INVOKES_STOP_CELL_EDITING_PROPERTY, oldValue, newValue);
    }

    public boolean getInvokesStopCellEditing() {
        return this.invokesStopCellEditing;
    }

    public boolean isCellEditable(Object cell) {
        CellView view;
        if (cell != null && (view = this.graphLayoutCache.getMapping(cell, false)) != null) {
            return this.isEditable() && GraphConstants.isEditable(view.getAllAttributes());
        }
        return false;
    }

    public String getToolTipText(MouseEvent event) {
        if (event != null) {
            Object cell = this.getFirstCellForLocation(event.getX(), event.getY());
            String s = this.convertValueToString(cell);
            return s != null && s.length() > 0 ? s : null;
        }
        return null;
    }

    public void setSelectionModel(GraphSelectionModel selectionModel) {
        if (selectionModel == null) {
            selectionModel = EmptySelectionModel.sharedInstance();
        }
        GraphSelectionModel oldValue = this.selectionModel;
        if (this.selectionModel != null && this.selectionRedirector != null) {
            this.selectionModel.removeGraphSelectionListener(this.selectionRedirector);
        }
        this.selectionModel = selectionModel;
        if (this.selectionRedirector != null) {
            this.selectionModel.addGraphSelectionListener(this.selectionRedirector);
        }
        this.firePropertyChange(SELECTION_MODEL_PROPERTY, oldValue, this.selectionModel);
    }

    public GraphSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
    }

    public boolean isSelectionEmpty() {
        return this.getSelectionModel().isSelectionEmpty();
    }

    public void addGraphSelectionListener(GraphSelectionListener tsl) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jgraph.event.GraphSelectionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, tsl);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.jgraph.event.GraphSelectionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (this.listenerList.getListenerCount(clazz2) != 0 && this.selectionRedirector == null) {
            this.selectionRedirector = new GraphSelectionRedirector();
            this.selectionModel.addGraphSelectionListener(this.selectionRedirector);
        }
    }

    public void removeGraphSelectionListener(GraphSelectionListener tsl) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jgraph.event.GraphSelectionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, tsl);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.jgraph.event.GraphSelectionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (this.listenerList.getListenerCount(clazz2) == 0 && this.selectionRedirector != null) {
            this.selectionModel.removeGraphSelectionListener(this.selectionRedirector);
            this.selectionRedirector = null;
        }
    }

    protected void fireValueChanged(GraphSelectionEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.jgraph.event.GraphSelectionListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                ((GraphSelectionListener)listeners[i + 1]).valueChanged(e);
            }
            i -= 2;
        }
    }

    public void setSelectionCell(Object cell) {
        this.getSelectionModel().setSelectionCell(cell);
    }

    public void setSelectionCells(Object[] cells) {
        this.getSelectionModel().setSelectionCells(cells);
    }

    public void addSelectionCell(Object cell) {
        this.getSelectionModel().addSelectionCell(cell);
    }

    public void addSelectionCells(Object[] cells) {
        this.getSelectionModel().addSelectionCells(cells);
    }

    public void removeSelectionCell(Object cell) {
        this.getSelectionModel().removeSelectionCell(cell);
    }

    public Object getSelectionCell() {
        return this.getSelectionModel().getSelectionCell();
    }

    public Object[] getSelectionCells() {
        return this.getSelectionModel().getSelectionCells();
    }

    public int getSelectionCount() {
        return this.getSelectionModel().getSelectionCount();
    }

    public boolean isCellSelected(Object cell) {
        return this.getSelectionModel().isCellSelected(cell);
    }

    public void scrollCellToVisible(Object cell) {
        Rectangle2D bounds = this.getCellBounds(cell);
        if (bounds != null) {
            Rectangle2D b2 = this.toScreen(bounds);
            this.scrollRectToVisible(new Rectangle((int)b2.getX(), (int)b2.getY(), (int)b2.getWidth(), (int)b2.getHeight()));
        }
    }

    public void scrollPointToVisible(Point2D p) {
        if (p != null) {
            this.scrollRectToVisible(new Rectangle((int)p.getX(), (int)p.getY(), 1, 1));
        }
    }

    public boolean isEditing() {
        GraphUI graph = this.getUI();
        if (graph != null) {
            return graph.isEditing(this);
        }
        return false;
    }

    public boolean stopEditing() {
        GraphUI graph = this.getUI();
        if (graph != null) {
            return graph.stopEditing(this);
        }
        return false;
    }

    public void cancelEditing() {
        GraphUI graph = this.getUI();
        if (graph != null) {
            graph.cancelEditing(this);
        }
    }

    public void startEditingAtCell(Object cell) {
        GraphUI graph = this.getUI();
        if (graph != null) {
            graph.startEditingAtCell(this, cell);
        }
    }

    public Object getEditingCell() {
        GraphUI graph = this.getUI();
        if (graph != null) {
            return graph.getEditingCell(this);
        }
        return null;
    }

    public void graphDidChange() {
        this.revalidate();
        this.repaint();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Vector<Object> values = new Vector<Object>();
        s.defaultWriteObject();
        if (this.graphModel instanceof Serializable) {
            values.addElement("graphModel");
            values.addElement(this.graphModel);
        }
        if (this.graphLayoutCache instanceof Serializable) {
            values.addElement("graphLayoutCache");
            values.addElement(this.graphLayoutCache);
        }
        if (this.selectionModel instanceof Serializable) {
            values.addElement(SELECTION_MODEL_PROPERTY);
            values.addElement(this.selectionModel);
        }
        s.writeObject(values);
        if (this.getUIClassID().equals(uiClassID) && this.ui != null) {
            this.ui.installUI(this);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Class<?> clazz;
        s.defaultReadObject();
        Vector values = (Vector)s.readObject();
        int indexCounter = 0;
        int maxCounter = values.size();
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals("graphModel")) {
            this.graphModel = (GraphModel)values.elementAt(++indexCounter);
            ++indexCounter;
        }
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals("graphLayoutCache")) {
            this.graphLayoutCache = (GraphLayoutCache)values.elementAt(++indexCounter);
            ++indexCounter;
        }
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals(SELECTION_MODEL_PROPERTY)) {
            this.selectionModel = (GraphSelectionModel)values.elementAt(++indexCounter);
            ++indexCounter;
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.jgraph.event.GraphSelectionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (this.listenerList.getListenerCount(clazz) != 0) {
            this.selectionRedirector = new GraphSelectionRedirector();
            this.selectionModel.addGraphSelectionListener(this.selectionRedirector);
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return 2;
        }
        return 4;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return orientation == 1 ? visibleRect.height : visibleRect.width;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    protected String paramString() {
        String editableString = this.editable ? "true" : "false";
        String invokesStopCellEditingString = this.invokesStopCellEditing ? "true" : "false";
        return String.valueOf(super.paramString()) + ",editable=" + editableString + ",invokesStopCellEditing=" + invokesStopCellEditingString;
    }

    public static void main(String[] args) {
        System.out.println(VERSION);
    }

    public static class EmptySelectionModel
    extends DefaultGraphSelectionModel {
        protected static final EmptySelectionModel sharedInstance = new EmptySelectionModel();

        public EmptySelectionModel() {
            super(null);
        }

        public static EmptySelectionModel sharedInstance() {
            return sharedInstance;
        }

        public void setSelectionCells(Object[] cells) {
        }

        public void addSelectionCells(Object[] cells) {
        }

        public void removeSelectionCells(Object[] cells) {
        }
    }

    protected class GraphSelectionRedirector
    implements Serializable,
    GraphSelectionListener {
        protected GraphSelectionRedirector() {
        }

        public void valueChanged(GraphSelectionEvent e) {
            GraphSelectionEvent newE = (GraphSelectionEvent)e.cloneWithSource(JGraph.this);
            JGraph.this.fireValueChanged(newE);
        }
    }
}

