/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.example;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.GraphCellEditor;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.plaf.basic.BasicGraphUI;

public class EditorGraph
extends JGraph {
    public EditorGraph() {
    }

    public EditorGraph(GraphModel model) {
        super(model);
    }

    public void updateUI() {
        this.setUI(new EditorGraphUI());
        this.invalidate();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("EditorGraph");
        frame.getContentPane().add(new EditorGraph());
        frame.pack();
        frame.setVisible(true);
    }

    public class EditorGraphUI
    extends BasicGraphUI {
        protected CellEditorListener cellEditorListener;
        protected JFrame editDialog = null;

        protected void createEditDialog(Object cell, MouseEvent event) {
            Dimension editorSize = this.editingComponent.getPreferredSize();
            this.editDialog = new JFrame("Edit " + this.graph.convertValueToString(cell));
            this.editDialog.setSize(editorSize.width, editorSize.height);
            this.editDialog.getContentPane().add(this.editingComponent);
            this.editingComponent.validate();
            this.editDialog.pack();
            this.editDialog.show();
        }

        protected void completeEditing(boolean messageStop, boolean messageCancel, boolean messageGraph) {
            if (this.stopEditingInCompleteEditing && this.editingComponent != null && this.editDialog != null) {
                Component oldComponent = this.editingComponent;
                Object oldCell = this.editingCell;
                GraphCellEditor oldEditor = this.cellEditor;
                Object newValue = oldEditor.getCellEditorValue();
                Rectangle2D editingBounds = this.graph.getCellBounds(this.editingCell);
                boolean requestFocus = this.graph != null && (this.graph.hasFocus() || this.editingComponent.hasFocus());
                this.editingCell = null;
                this.editingComponent = null;
                if (messageStop) {
                    oldEditor.stopCellEditing();
                } else if (messageCancel) {
                    oldEditor.cancelCellEditing();
                }
                this.editDialog.dispose();
                if (requestFocus) {
                    this.graph.requestFocus();
                }
                if (messageGraph) {
                    AttributeMap map = EditorGraph.this.getModel().createAttributes();
                    GraphConstants.setValue(map, newValue);
                    Hashtable<Object, AttributeMap> nested = new Hashtable<Object, AttributeMap>();
                    nested.put(oldCell, map);
                    this.graphLayoutCache.edit(nested, null, null, null);
                }
                this.updateSize();
                if (oldEditor != null && this.cellEditorListener != null) {
                    oldEditor.removeCellEditorListener(this.cellEditorListener);
                }
                this.cellEditor = null;
                this.editDialog = null;
            }
        }

        protected boolean startEditing(Object cell, MouseEvent event) {
            this.completeEditing();
            if (this.graph.isCellEditable(cell) && this.editDialog == null) {
                CellView tmp = this.graphLayoutCache.getMapping(cell, false);
                this.cellEditor = tmp.getEditor();
                this.editingComponent = this.cellEditor.getGraphCellEditorComponent(this.graph, cell, this.graph.isCellSelected(cell));
                if (this.cellEditor.isCellEditable(event)) {
                    this.editingCell = cell;
                    this.createEditDialog(cell, event);
                    if (this.cellEditorListener == null) {
                        this.cellEditorListener = this.createCellEditorListener();
                    }
                    if (this.cellEditor != null && this.cellEditorListener != null) {
                        this.cellEditor.addCellEditorListener(this.cellEditorListener);
                    }
                    if (this.cellEditor.shouldSelectCell(event)) {
                        this.stopEditingInCompleteEditing = false;
                        try {
                            this.graph.setSelectionCell(cell);
                        }
                        catch (Exception e) {
                            System.err.println("Editing exception: " + e);
                        }
                        this.stopEditingInCompleteEditing = true;
                    }
                    if (event instanceof MouseEvent) {
                        Point componentPoint = SwingUtilities.convertPoint(this.graph, new Point(event.getX(), event.getY()), this.editingComponent);
                        Component activeComponent = SwingUtilities.getDeepestComponentAt(this.editingComponent, componentPoint.x, componentPoint.y);
                        if (activeComponent != null) {
                            new BasicGraphUI.MouseInputHandler(this.graph, activeComponent, event);
                        }
                    }
                    return true;
                }
                this.editingComponent = null;
            }
            return false;
        }
    }
}

