/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.example;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.TransferHandler;
import javax.swing.event.UndoableEditEvent;
import org.jgraph.JGraph;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.example.MyMarqueeHandler;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.Edge;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphUndoManager;
import org.jgraph.graph.ParentMap;
import org.jgraph.graph.Port;

public class GraphEd
extends JPanel
implements GraphSelectionListener,
KeyListener {
    protected JGraph graph;
    protected GraphUndoManager undoManager;
    protected Action undo;
    protected Action redo;
    protected Action remove;
    protected Action group;
    protected Action ungroup;
    protected Action tofront;
    protected Action toback;
    protected Action cut;
    protected Action copy;
    protected Action paste;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        URL jgraphUrl;
        JFrame frame = new JFrame("GraphEd");
        frame.getContentPane().add(new GraphEd());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jgraph.example.GraphEd");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((jgraphUrl = clazz.getClassLoader().getResource("org/jgraph/example/resources/jgraph.gif")) != null) {
            ImageIcon jgraphIcon = new ImageIcon(jgraphUrl);
            frame.setIconImage(jgraphIcon.getImage());
        }
        frame.setSize(520, 390);
        frame.show();
    }

    public GraphEd() {
        this.setLayout(new BorderLayout());
        this.graph = new MyGraph(new MyModel());
        this.undoManager = new GraphUndoManager(){

            public void undoableEditHappened(UndoableEditEvent e) {
                super.undoableEditHappened(e);
                GraphEd.this.updateHistoryButtons();
            }
        };
        this.graph.getModel().addUndoableEditListener(this.undoManager);
        this.graph.getSelectionModel().addGraphSelectionListener(this);
        this.graph.addKeyListener(this);
        this.add((Component)this.createToolBar(), "North");
        this.add((Component)new JScrollPane(this.graph), "Center");
    }

    public void insert(Point2D point) {
        DefaultGraphCell vertex = new DefaultGraphCell();
        vertex.add(new DefaultPort());
        AttributeMap map = this.graph.getModel().createAttributes();
        point = this.graph.snap(map.createPoint(point));
        Dimension size = new Dimension(25, 25);
        GraphConstants.setBounds(map, map.createRect(point.getX(), point.getY(), size.width, size.height));
        GraphConstants.setBorderColor(map, Color.black);
        GraphConstants.setBackground(map, Color.white);
        GraphConstants.setOpaque(map, true);
        Hashtable<DefaultGraphCell, AttributeMap> attributes = new Hashtable<DefaultGraphCell, AttributeMap>();
        attributes.put(vertex, map);
        this.graph.getGraphLayoutCache().insert(new Object[]{vertex}, attributes, null, null, null);
    }

    public void connect(Port source, Port target) {
        ConnectionSet cs = new ConnectionSet();
        DefaultEdge edge = new DefaultEdge();
        cs.connect((Object)edge, (Object)source, target);
        AttributeMap map = this.graph.getModel().createAttributes();
        GraphConstants.setLineEnd(map, 4);
        GraphConstants.setLabelAlongEdge(map, true);
        Hashtable<DefaultEdge, AttributeMap> attributes = new Hashtable<DefaultEdge, AttributeMap>();
        attributes.put(edge, map);
        this.graph.getGraphLayoutCache().insert(new Object[]{edge}, attributes, cs, null, null);
    }

    public void group(Object[] cells) {
        cells = this.graph.getGraphLayoutCache().order(cells);
        if (cells != null && cells.length > 0) {
            int count = this.getCellCount(this.graph);
            DefaultGraphCell group = new DefaultGraphCell(new Integer(count - 1));
            ParentMap map = new ParentMap();
            int i = 0;
            while (i < cells.length) {
                map.addEntry(cells[i], group);
                ++i;
            }
            this.graph.getGraphLayoutCache().insert(new Object[]{group}, null, null, map, null);
        }
    }

    protected int getCellCount(JGraph graph) {
        Object[] cells = graph.getDescendants(graph.getRoots());
        return cells.length;
    }

    public void ungroup(Object[] cells) {
        if (cells != null && cells.length > 0) {
            ArrayList<Object> groups = new ArrayList<Object>();
            ArrayList<Object> children = new ArrayList<Object>();
            int i = 0;
            while (i < cells.length) {
                if (this.isGroup(cells[i])) {
                    groups.add(cells[i]);
                    int j = 0;
                    while (j < this.graph.getModel().getChildCount(cells[i])) {
                        Object child = this.graph.getModel().getChild(cells[i], j);
                        if (!(child instanceof Port)) {
                            children.add(child);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.graph.getGraphLayoutCache().remove(groups.toArray());
            this.graph.setSelectionCells(children.toArray());
        }
    }

    public boolean isGroup(Object cell) {
        CellView view = this.graph.getGraphLayoutCache().getMapping(cell, false);
        if (view != null) {
            return !view.isLeaf();
        }
        return false;
    }

    public void toFront(Object[] c) {
        this.graph.getGraphLayoutCache().toFront(c);
    }

    public void toBack(Object[] c) {
        this.graph.getGraphLayoutCache().toBack(c);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void undo() {
        try {
            try {
                this.undoManager.undo(this.graph.getGraphLayoutCache());
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.updateHistoryButtons();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.updateHistoryButtons();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void redo() {
        try {
            try {
                this.undoManager.redo(this.graph.getGraphLayoutCache());
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.updateHistoryButtons();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.updateHistoryButtons();
            return;
        }
    }

    protected void updateHistoryButtons() {
        this.undo.setEnabled(this.undoManager.canUndo(this.graph.getGraphLayoutCache()));
        this.redo.setEnabled(this.undoManager.canRedo(this.graph.getGraphLayoutCache()));
    }

    public void valueChanged(GraphSelectionEvent e) {
        this.group.setEnabled(this.graph.getSelectionCount() > 1);
        boolean enabled = !this.graph.isSelectionEmpty();
        this.remove.setEnabled(enabled);
        this.ungroup.setEnabled(enabled);
        this.tofront.setEnabled(enabled);
        this.toback.setEnabled(enabled);
        this.copy.setEnabled(enabled);
        this.cut.setEnabled(enabled);
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            this.remove.actionPerformed(null);
        }
    }

    public JPopupMenu createPopupMenu(final Point pt, final Object cell) {
        JPopupMenu menu = new JPopupMenu();
        if (cell != null) {
            menu.add(new AbstractAction("Edit"){

                public void actionPerformed(ActionEvent e) {
                    GraphEd.this.graph.startEditingAtCell(cell);
                }
            });
        }
        if (!this.graph.isSelectionEmpty()) {
            menu.addSeparator();
            menu.add(new AbstractAction("Remove"){

                public void actionPerformed(ActionEvent e) {
                    GraphEd.this.remove.actionPerformed(e);
                }
            });
        }
        menu.addSeparator();
        menu.add(new AbstractAction("Insert"){

            public void actionPerformed(ActionEvent ev) {
                GraphEd.this.insert(pt);
            }
        });
        return menu;
    }

    public JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        URL insertUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/insert.gif");
        ImageIcon insertIcon = new ImageIcon(insertUrl);
        toolbar.add(new AbstractAction("", insertIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEd.this.insert(new Point(10, 10));
            }
        });
        URL connectUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/connecton.gif");
        ImageIcon connectIcon = new ImageIcon(connectUrl);
        toolbar.add(new AbstractAction("", connectIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEd.this.graph.setPortsVisible(!GraphEd.this.graph.isPortsVisible());
                URL connectUrl = GraphEd.this.graph.isPortsVisible() ? this.getClass().getClassLoader().getResource("org/jgraph/example/resources/connecton.gif") : this.getClass().getClassLoader().getResource("org/jgraph/example/resources/connectoff.gif");
                ImageIcon connectIcon = new ImageIcon(connectUrl);
                this.putValue("SmallIcon", connectIcon);
            }
        });
        toolbar.addSeparator();
        URL undoUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/undo.gif");
        ImageIcon undoIcon = new ImageIcon(undoUrl);
        this.undo = new AbstractAction("", undoIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEd.this.undo();
            }
        };
        this.undo.setEnabled(false);
        toolbar.add(this.undo);
        URL redoUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/redo.gif");
        ImageIcon redoIcon = new ImageIcon(redoUrl);
        this.redo = new AbstractAction("", redoIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEd.this.redo();
            }
        };
        this.redo.setEnabled(false);
        toolbar.add(this.redo);
        toolbar.addSeparator();
        Action action = TransferHandler.getCopyAction();
        URL url = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/copy.gif");
        action.putValue("SmallIcon", new ImageIcon(url));
        this.copy = new EventRedirector(action);
        toolbar.add(this.copy);
        action = TransferHandler.getPasteAction();
        url = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/paste.gif");
        action.putValue("SmallIcon", new ImageIcon(url));
        this.paste = new EventRedirector(action);
        toolbar.add(this.paste);
        action = TransferHandler.getCutAction();
        url = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/cut.gif");
        action.putValue("SmallIcon", new ImageIcon(url));
        this.cut = new EventRedirector(action);
        toolbar.add(this.cut);
        URL removeUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/delete.gif");
        ImageIcon removeIcon = new ImageIcon(removeUrl);
        this.remove = new AbstractAction("", removeIcon){

            public void actionPerformed(ActionEvent e) {
                if (!GraphEd.this.graph.isSelectionEmpty()) {
                    Object[] cells = GraphEd.this.graph.getSelectionCells();
                    cells = GraphEd.this.graph.getDescendants(cells);
                    GraphEd.this.graph.getModel().remove(cells);
                }
            }
        };
        this.remove.setEnabled(false);
        toolbar.add(this.remove);
        toolbar.addSeparator();
        URL zoomUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/zoom.gif");
        ImageIcon zoomIcon = new ImageIcon(zoomUrl);
        toolbar.add(new AbstractAction("", zoomIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEd.this.graph.setScale(1.0);
            }
        });
        URL zoomInUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/zoomin.gif");
        ImageIcon zoomInIcon = new ImageIcon(zoomInUrl);
        toolbar.add(new AbstractAction("", zoomInIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEd.this.graph.setScale(2.0 * GraphEd.this.graph.getScale());
            }
        });
        URL zoomOutUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/zoomout.gif");
        ImageIcon zoomOutIcon = new ImageIcon(zoomOutUrl);
        toolbar.add(new AbstractAction("", zoomOutIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEd.this.graph.setScale(GraphEd.this.graph.getScale() / 2.0);
            }
        });
        toolbar.addSeparator();
        URL groupUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/group.gif");
        ImageIcon groupIcon = new ImageIcon(groupUrl);
        this.group = new AbstractAction("", groupIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEd.this.group(GraphEd.this.graph.getSelectionCells());
            }
        };
        this.group.setEnabled(false);
        toolbar.add(this.group);
        URL ungroupUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/ungroup.gif");
        ImageIcon ungroupIcon = new ImageIcon(ungroupUrl);
        this.ungroup = new AbstractAction("", ungroupIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEd.this.ungroup(GraphEd.this.graph.getSelectionCells());
            }
        };
        this.ungroup.setEnabled(false);
        toolbar.add(this.ungroup);
        toolbar.addSeparator();
        URL toFrontUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/tofront.gif");
        ImageIcon toFrontIcon = new ImageIcon(toFrontUrl);
        this.tofront = new AbstractAction("", toFrontIcon){

            public void actionPerformed(ActionEvent e) {
                if (!GraphEd.this.graph.isSelectionEmpty()) {
                    GraphEd.this.toFront(GraphEd.this.graph.getSelectionCells());
                }
            }
        };
        this.tofront.setEnabled(false);
        toolbar.add(this.tofront);
        URL toBackUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/toback.gif");
        ImageIcon toBackIcon = new ImageIcon(toBackUrl);
        this.toback = new AbstractAction("", toBackIcon){

            public void actionPerformed(ActionEvent e) {
                if (!GraphEd.this.graph.isSelectionEmpty()) {
                    GraphEd.this.toBack(GraphEd.this.graph.getSelectionCells());
                }
            }
        };
        this.toback.setEnabled(false);
        toolbar.add(this.toback);
        return toolbar;
    }

    public class MyGraph
    extends JGraph {
        public MyGraph(GraphModel model) {
            super(model);
            this.setMarqueeHandler(new MyMarqueeHandler(GraphEd.this));
            this.setSelectNewCells(true);
            this.setPortsVisible(true);
            this.setGridEnabled(true);
            this.setGridSize(6.0);
            this.setTolerance(2);
            this.setInvokesStopCellEditing(true);
        }

        protected EdgeView createEdgeView(JGraph graph, CellMapper cm, Object cell) {
            return new EdgeView(this, cell, graph, cm){
                final /* synthetic */ MyGraph this$1;
                {
                    this.this$1 = myGraph;
                }

                public CellHandle getHandle(GraphContext context) {
                    return MyGraph.access$0(this.this$1).new MyEdgeHandle(this, context);
                }
            };
        }

        static /* synthetic */ GraphEd access$0(MyGraph myGraph) {
            return myGraph.GraphEd.this;
        }
    }

    public class MyEdgeHandle
    extends EdgeView.EdgeHandle {
        public MyEdgeHandle(EdgeView edge, GraphContext ctx) {
            super(edge, ctx);
        }

        public boolean isAddPointEvent(MouseEvent event) {
            return event.isShiftDown();
        }

        public boolean isRemovePointEvent(MouseEvent event) {
            return event.isShiftDown();
        }
    }

    public static class MyModel
    extends DefaultGraphModel {
        public boolean acceptsSource(Object edge, Object port) {
            return ((Edge)edge).getTarget() != port;
        }

        public boolean acceptsTarget(Object edge, Object port) {
            return ((Edge)edge).getSource() != port;
        }
    }

    protected class EventRedirector
    extends AbstractAction {
        protected Action action;

        public EventRedirector(Action a) {
            super("", (ImageIcon)a.getValue("SmallIcon"));
            this.action = a;
        }

        public void actionPerformed(ActionEvent e) {
            e = new ActionEvent(GraphEd.this.graph, e.getID(), e.getActionCommand(), e.getModifiers());
            this.action.actionPerformed(e);
        }
    }
}

