/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.example;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.UndoableEditEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.example.GraphEd;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphUndoManager;

public class GraphEdMV
extends GraphEd
implements GraphSelectionListener,
KeyListener {
    protected static GraphModel model;
    protected static GraphUndoManager undoManager;
    protected static ArrayList instances;
    protected Action undo;
    protected Action redo;
    protected Action remove;
    protected Action group;
    protected Action ungroup;
    protected Action tofront;
    protected Action toback;
    protected Action cut;
    protected Action copy;
    protected Action paste;
    static /* synthetic */ Class class$0;

    static {
        undoManager = new GraphUndoManager(){

            public void undoableEditHappened(UndoableEditEvent e) {
                super.undoableEditHappened(e);
                GraphEdMV.updateAllHistoryButtons();
            }
        };
        instances = new ArrayList();
    }

    public static void main(String[] args) {
        URL jgraphUrl;
        model = new GraphEd.MyModel();
        model.addUndoableEditListener(undoManager);
        JFrame frame = new JFrame("GraphEdMV");
        GraphEdMV e1 = new GraphEdMV();
        GraphEdMV e2 = new GraphEdMV();
        instances.add(e1);
        instances.add(e2);
        frame.getContentPane().add(new JSplitPane(1, e1, e2));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jgraph.example.GraphEdMV");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((jgraphUrl = clazz.getClassLoader().getResource("org/jgraph/example/resources/jgraph.gif")) != null) {
            ImageIcon jgraphIcon = new ImageIcon(jgraphUrl);
            frame.setIconImage(jgraphIcon.getImage());
        }
        frame.pack();
        frame.setSize(new Dimension(frame.getWidth(), 400));
        frame.show();
    }

    public GraphEdMV() {
        this.setLayout(new BorderLayout());
        this.graph = new GraphEd.MyGraph(model);
        HashSet<String> localAttributes = new HashSet<String>();
        localAttributes.add("bounds");
        localAttributes.add("points");
        localAttributes.add("labelposition");
        localAttributes.add("routing");
        this.graph.getGraphLayoutCache().setLocalAttributes(localAttributes);
        this.graph.getSelectionModel().addGraphSelectionListener(this);
        this.graph.addKeyListener(this);
        this.add((Component)this.createToolBar(), "North");
        this.add((Component)new JScrollPane(this.graph), "Center");
    }

    public void group(Object[] cells) {
        Object[] tmp = new Object[cells.length];
        int i = 0;
        while (i < cells.length) {
            tmp[cells.length - i - 1] = cells[i];
            ++i;
        }
        cells = tmp;
        super.group(tmp);
    }

    protected static void updateAllHistoryButtons() {
        Iterator it = instances.iterator();
        while (it.hasNext()) {
            ((GraphEdMV)it.next()).updateHistoryButtons();
        }
    }
}

